/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction T(
pmatrix mW,
pmatrix mu,
pmatrix mu0)
{
  return(innerprod_W(mW,mu,mu0));
}
/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void AB(int n)
{
fraction c;
fraction Tu;
fraction Tv;
fraction Tcu;
fraction cTu;
fraction T_uplsv;
fraction TuplsTv;

double pbW     [MXR][MXC*TWOCOL];matrix mW     ={MXR,MXC*TWOCOL,&pbW   [0][0]};
double pbu     [MXR][MXC*TWOCOL];matrix mu     ={MXR,MXC*TWOCOL,&pbu   [0][0]};
double pbu0    [MXR][MXC*TWOCOL];matrix mu0    ={MXR,MXC*TWOCOL,&pbu0  [0][0]};
double pbv     [MXR][MXC*TWOCOL];matrix mv     ={MXR,MXC*TWOCOL,&pbv   [0][0]};
double puplsv  [MXR][MXC*TWOCOL];matrix muplsv ={MXR,MXC*TWOCOL,&puplsv[0][0]};
double pbcu    [MXR][MXC*TWOCOL];matrix mcu    ={MXR,MXC*TWOCOL,&pbcu  [0][0]};

                     mW.rows=n;                   mW.cols=n*TWOCOL;
                     mu.rows=n;                   mu.cols=1*TWOCOL;
                    mu0.rows=n;                  mu0.cols=1*TWOCOL;
                     mv.rows=n;                   mv.cols=1*TWOCOL;
                 muplsv.rows=n;               muplsv.cols=1*TWOCOL;
                    mcu.rows=n;                  mcu.cols=1*TWOCOL;
/*-------------------------------- PROGRuM ---------------------------------- */
    c = rndF(     5,1);

     mdiagpF(&mW, 5,1);
       rndmF(&mu, 5,1);
       rndmF(&mv, 5,1);
       rndmF(&mu0,5,1);

  clrscrn();
  printf(" a) T : R**n->R, T(u) = <u,u0> (where u0 is a fixed vector)\n");
  printf("          Is T(u) + T(v) = T(u + v) ?\n\n");
  printf("  Copy the weights w1,..,wn on the identity matrix : W\n");
  printmI(&mW);
  printf("                                                   : u");
  printmI(&mu);
  printf("                                                   : v");
  printmI(&mv);
  printf("                                                   : u0");
  printmI(&mu0);
  getchar();

  clrscrn();
  Tu = T(&mW,&mu,&mu0);
  printf("\n\n T(u) = %.0lf\n", Tu.numer);
  Tv = T(&mW,&mv,&mu0);
  printf("\n T(v) = %.0lf\n", Tv.numer);
  TuplsTv = addF(Tu,Tv);
  printf("\n          T(u) + T(v) = %.0lf\n", TuplsTv.numer);
  printf("\n                                                   u + v :");
  addmF(&mu,&mv,  &muplsv);
  printmI3(       &muplsv);
  T_uplsv = T(&mW,&muplsv,&mu0);
  printf("\n               T(u+v) = %.0lf\n", T_uplsv.numer);
  getchar();

  clrscrn();
  printf(" b) T : R**n->R, T(u) = <u,u0> (where u0 is a fixed vector)\n");
  printf("           Is T(cu) =  cT(u) ? \n");
  printf("                                                      u :\n");
  printmI3(&mu);
  printf("                                               c = %4.0f :\n\n",c.numer);
  smultmF(c,&mu,&mcu);
  printf("                                                    cfu :\n");
  printmI3(&mcu);
  Tcu = T(&mW,&mcu,&mu0);
  printf("                                     T(cu) = %.0lf\n", Tcu.numer);
  Tu = T(&mW,&mu,&mu0);
  printf("   T(u) = %.0lf\n", Tu.numer);
  cTu = multF(c,Tu);
  printf("                                     cT(u) = %.0lf\n", cTu.numer);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n\n\n                                        \n");
  printf("              T : R** -> R,                     \n\n");
  printf("   T(u) = <u,u0> (where u0 is a fixed vector)   \n\n");
  printf("\n    Weighed Euclidean Inner Product on R**n : \n\n");
  printf("               ****************                   \n");
  printf("\n\n\n\n                                            ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 2){n=2;}


  AB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



