/* gaussjordan4.c                   freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
fraction InnerProduv;

double pbU1 [MXR][MXC*TWOCOL];matrix mU1={MXR,MXC*TWOCOL,&pbU1[0][0]};
double pbU2 [MXR][MXC*TWOCOL];matrix mU2={MXR,MXC*TWOCOL,&pbU2[0][0]};

double pbV1 [MXR][MXC*TWOCOL];matrix mV1={MXR,MXC*TWOCOL,&pbV1[0][0]};
double pbV2 [MXR][MXC*TWOCOL];matrix mV2={MXR,MXC*TWOCOL,&pbV2[0][0]};

double pvaT[MXR][MXC*TWOCOL];matrix mvaT={MXR,MXC*TWOCOL,&pvaT[0][0]};
double pvbT[MXR][MXC*TWOCOL];matrix mvbT={MXR,MXC*TWOCOL,&pvbT[0][0]};

    mU1.rows = 2;           mU1.cols = 2*TWOCOL;
    mU2.rows = 2;           mU2.cols = 2*TWOCOL;

    mV1.rows = 2;           mV1.cols = 2*TWOCOL;
    mV2.rows = 2;           mV2.cols = 2*TWOCOL;

   mvaT.rows = 2;          mvaT.cols = 2*TWOCOL;
   mvbT.rows = 2;          mvbT.cols = 2*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mU1,3,1);
  rndmF(&mU2,3,1);

   clrscrn();
   printf(" Consider these vectors generated randomly by the computer\n");
   printmF(&mU1);
   printmF(&mU2);

   InnerProduv = innerprod_Mnm(&mU1,&mU2);
   printf("\n With  the inner product in M2x2.\n");
   printf("\n <U1,U2> = %4.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
   getchar();

   clrscrn();
        copymF(&mU1,&mV1);         /*v1*/

    projwn_Mnm(&mU2,&mV1, &mvbT);
         submF(&mU2,&mvbT,&mV2);   /*v2*/

   printf("\n If these vectors are linear independent,");
   printf("\n and if we apply the Gram-Schmidt process on them,");
   printf("\n we obtain these orthogonal vectors.\n");
   printf("\n If V2 = 0, U1 and U2 are linear dependent.\n\n");
   printmF(&mV1);
   printmF(&mV2);

   InnerProduv = innerprod_Mnm(&mV1,&mV2);
   printf("\n   <V1,V2> = %.0lf/%-.0lf \n",InnerProduv.numer,InnerProduv.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n\n\n                                          \n");
  printf("          The Gram-Schmidt process,               \n");
  printf("        with  the inner product in M2x2           \n");
  printf("        *******************************             ");
  printf("\n\n\n \n\n\n\n\n\n\n\n                             ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                         ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{


  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}


