/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB()
{
fraction InnerProduct_uv;
fraction InnerProduct_k_uv;
fraction InnerProduct_ku_v;
fraction k;

double pbu    [2][2*TWOCOL];matrix mu    ={2,2*TWOCOL,&pbu    [0][0]};
double pbku   [2][2*TWOCOL];matrix mku   ={2,2*TWOCOL,&pbku   [0][0]};
double pbv    [2][2*TWOCOL];matrix mv    ={2,2*TWOCOL,&pbv    [0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */
       rndmF(&mu,5,3);
       rndmF(&mv,5,3);
  k =  rndF (    5,3);

  clrscrn();
  printf("                                 U");
  printmF3(&mu);
  printf("                                 V");
  printmF3(&mv);
  printf("\n\n    k = %.0lf/%-.0lf \n\n\n",k.numer,k.denom);

  smultmF(k,&mu,&mku);
  printf("                               kU\n");
  printmF3(&mku);

  InnerProduct_ku_v = innerprod_Mnm(&mku,&mv);
  printf("\n\n\n <kU,V> =  %.0lf/%-.0lf ",
            InnerProduct_ku_v.numer,
            InnerProduct_ku_v.denom);

  InnerProduct_uv = innerprod_Mnm(&mu,&mv);
  printf("\n\n\n k<U,V> = (%.0lf/%-.0lf) (%.0lf/%-.0lf) \n\n",
            k.numer,
            k.denom,
            InnerProduct_uv.numer,
            InnerProduct_uv.denom);
  getchar();

  clrscrn();
  printf("\n  Properties of inner product in M2x2 :\n");
  printf("\n             (Homogeneity axiom)     \n\n\n");
  printf("   <kU,V> =  %.0lf/%-.0lf\n\n",
            InnerProduct_ku_v.numer,
            InnerProduct_ku_v.denom);

  InnerProduct_k_uv = multF(k,InnerProduct_uv);
  printf("   k<U,V> =  %.0lf/%-.0lf\n\n",
            InnerProduct_k_uv.numer,
            InnerProduct_k_uv.denom);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n  Properties of inner product in M2x2 :         \n");
  printf("\n             (Homogeneity axiom)                \n");
  printf("\n\n\n                                              ");
  printf("\n               <kU,V>  =  k<U,V>                  ");
  printf("\n               *****************                  ");
  printf("\n\n\n\n\n                                          ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
int main()
{
time_t t;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{

  AB();


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












