/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction k;
fraction l;
fraction kl;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pblu   [MXR][MXC*TWOCOL];matrix mlu   ={MXR,MXC*TWOCOL,&pblu   [0][0]};
double pbk_lu [MXR][MXC*TWOCOL];matrix mk_lu ={MXR,MXC*TWOCOL,&pbk_lu [0][0]};
double pbkl_u [MXR][MXC*TWOCOL];matrix mkl_u ={MXR,MXC*TWOCOL,&pbkl_u [0][0]};

double pk_lu_mns_kl_u[MXR][MXC*TWOCOL];
matrix mk_lu_mns_kl_u={MXR,MXC*TWOCOL,&pk_lu_mns_kl_u[0][0]};

if(vectrow)
  {
                 mu.rows = 1;               mu.cols = n*TWOCOL;
                mlu.rows = 1;              mlu.cols = n*TWOCOL;
              mk_lu.rows = 1;            mk_lu.cols = n*TWOCOL;
              mkl_u.rows = 1;            mkl_u.cols = n*TWOCOL;
     mk_lu_mns_kl_u.rows = 1;   mk_lu_mns_kl_u.cols = n*TWOCOL;
  }
else
  {
                 mu.rows = n;               mu.cols = 1*TWOCOL;
                mlu.rows = n;              mlu.cols = 1*TWOCOL;
              mk_lu.rows = n;            mk_lu.cols = 1*TWOCOL;
              mkl_u.rows = n;            mkl_u.cols = 1*TWOCOL;
     mk_lu_mns_kl_u.rows = n;   mk_lu_mns_kl_u.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  k = rndFI (5);
  l = rndFI (5);

  rndmI(&mu,5);

  clrscrn();
  printf("                                l = %3.0f\n", l.numer);

  printf("                                 u");
  printmI3(&mu);
  printf("                                lu");
  smultmF(l,&mu,&mlu);
  printmI3(     &mlu);
  printf("                              k = %3.0f\n", k.numer);
  printf("                              k(lu)");
  smultmF(k,&mlu,&mk_lu);
  printmI3(      &mk_lu);
  getchar();

  clrscrn();
  printf("                                 k = %3.0f\n", k.numer);
  printf("                                 l = %3.0f\n", l.numer);
  kl = multF(k,l);
  printf("                                kl = %3.0f\n", kl.numer);

  printf("                                 u");
  printmI3(&mu);
  printf("                             (kl)u");
  smultmF(kl,&mu,&mkl_u);
  printmI3(      &mkl_u);
  getchar();

  clrscrn();
  printf("                             k(lu)");
  printmI3(&mk_lu);
  printf("                            (kl)u)");
  printmI3(&mkl_u);
  printf("                  [k(lu)] - [kl)u]");
  submF(&mk_lu, &mkl_u,&mk_lu_mns_kl_u);
  printmI3(            &mk_lu_mns_kl_u);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n              [k(lu)] = [kl)u]                    ");
  printf("\n              ****************                    ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"vgI.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"vgI.exe 2\" -> 2x1  (1x2)             ");
  printf("\n          \"vgI.exe 4\" -> 4x1  (1x4)           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {    n=rndpI(4);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












