/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
AB(
int n,
int vectrow)
{
fraction k;

double pbu    [MXR][MXC*TWOCOL];matrix mu    ={MXR,MXC*TWOCOL,&pbu    [0][0]};
double pbv    [MXR][MXC*TWOCOL];matrix mv    ={MXR,MXC*TWOCOL,&pbv    [0][0]};
double pbuplsv[MXR][MXC*TWOCOL];matrix muplsv={MXR,MXC*TWOCOL,&pbuplsv[0][0]};
double pbku   [MXR][MXC*TWOCOL];matrix mku   ={MXR,MXC*TWOCOL,&pbku   [0][0]};
double pbkv   [MXR][MXC*TWOCOL];matrix mkv   ={MXR,MXC*TWOCOL,&pbkv   [0][0]};

double pk_uplsv[MXR][MXC*TWOCOL];matrix mk_uplsv={MXR,MXC*TWOCOL,&pk_uplsv[0][0]};
double pkuplskv[MXR][MXC*TWOCOL];matrix mkuplskv={MXR,MXC*TWOCOL,&pkuplskv[0][0]};

double pk_uplsv_mns_kuplskv[MXR][MXC*TWOCOL];
matrix mk_uplsv_mns_kuplskv={MXR,MXC*TWOCOL,&pk_uplsv_mns_kuplskv[0][0]};

if(vectrow)
  {
           mu.rows = 1;                   mu.cols = n*TWOCOL;
           mv.rows = 1;                   mv.cols = n*TWOCOL;
       muplsv.rows = 1;               muplsv.cols = n*TWOCOL;
          mku.rows = 1;                  mku.cols = n*TWOCOL;
          mkv.rows = 1;                  mkv.cols = n*TWOCOL;
     mk_uplsv.rows = 1;             mk_uplsv.cols = n*TWOCOL;
     mkuplskv.rows = 1;             mkuplskv.cols = n*TWOCOL;

     mk_uplsv_mns_kuplskv.rows = 1;
     mk_uplsv_mns_kuplskv.cols = n*TWOCOL;
  }
else
  {
           mu.rows = n;                   mu.cols = 1*TWOCOL;
           mv.rows = n;                   mv.cols = 1*TWOCOL;
       muplsv.rows = n;               muplsv.cols = 1*TWOCOL;
          mku.rows = n;                  mku.cols = 1*TWOCOL;
          mkv.rows = n;                  mkv.cols = 1*TWOCOL;
     mk_uplsv.rows = n;             mk_uplsv.cols = 1*TWOCOL;
     mkuplskv.rows = n;             mkuplskv.cols = 1*TWOCOL;

     mk_uplsv_mns_kuplskv.rows = n;
     mk_uplsv_mns_kuplskv.cols = 1*TWOCOL;
   }
/*-------------------------------- PROGRAM ---------------------------------- */
  k = rndFI(5);

  rndmI(&mu,5);
  rndmI(&mv,5);

  clrscrn();
  printf("                                 k = %.0f\n", k.numer);
  printf("                                 u");
  printmI3(&mu);
  printf("                                 v");
  printmI3(&mv);
  printf("                             u + v");
  addmF(&mu,&mv,&muplsv);
  printmI3(     &muplsv);
  printf("                           k(u + v)");
  smultmF(k,&muplsv,&mk_uplsv);
  printmI3(         &mk_uplsv);
  getchar();

  clrscrn();
  printf("                                ku");
  smultmF(k,&mu,&mku);
  printmI3(&mku);
  printf("                                kv");
  smultmF(k,&mv,&mkv);
  printmI3(&mkv);
  printf("                           ku + kv");
  addmF(&mku,&mkv,&mkuplskv);
  printmI3(       &mkuplskv);
  getchar();

  clrscrn();
  printf("                          k(u + v)");
  printmI3(&mk_uplsv);
  printf("                           ku + kv");
  printmI3(&mkuplskv);
  printf("            [k(u + v)] - [ku + kv]");
  submF(&mk_uplsv,&mkuplskv,&mk_uplsv_mns_kuplskv);
  printmI3(                 &mk_uplsv_mns_kuplskv);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.  ");
  printf("\n\n                                                ");
  printf("\n            Vector space axioms.                  ");
  printf("\n                                                  ");
  printf("\n             k(u + v) = ku + kv                   ");
  printf("\n             ******************                   ");
  printf("\n\n\n                                              ");
  printf("\n The size of u, v : 2x1 ... 4x1.                \n");
  printf("\n     ex : \"veI.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"veI.exe 2\" -> 2x1  (1x2)             ");
  printf("\n          \"veI.exe 4\" -> 4x1  (1x4)           \n");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
int main(int argc, char *argv[])
{
time_t t;
int    n;
int    vectrow = 1;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {    n=rndpI(4);}
   if(n<2){n=2;}

if( vectrow){vectrow = 0;}
else        {vectrow = 1;}


  AB(n,vectrow);


  printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












