/* settest.c
 */

#include <conio.h>
#include <string.h>
#include <stdio.h>
#include "simc.h"

#define N 6

void Pause( void);
int  PrintD( char *);

/*--------------------------------------------------------*/
void main( void)
{
  int     i;
  Set_ID  S;
  char   *D[ N] =
    {
      "Data 1",
      "Data 2",
      "Data 3",
      "Data 4",
      "Data 5",
      "Data 6"
    };

  S = SetCreate();

/*--------------------------------------------------------*/
                                             /* SaveFirst */
                                             /*-----------*/
  for( i= 0; i< N; i++) SetSaveFirst( S, D[ i]);

  printf( "Save First and List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
                                                  /* Read */
                                                  /*------*/
  printf( "ReadLast : %s\n", SetReadLast( S));
  printf( "Read%5d: %s\n", N/2, SetRead( S, N/2));
  printf( "ReadFirst: %s\n", SetReadFirst( S));

  for( i= 1; i< SetSize( S); i++)
    printf( "ReadNext : %s\n", SetReadNext( S));
  Pause();

/*--------------------------------------------------------*/
                                               /* ForEach */
                                               /*---------*/
  {
    Pointer _D;
    printf( "ForEach\n");
    ForEach( _D, S) printf( "printf: %s\n", _D);
  }
  Pause();
/*--------------------------------------------------------*/
                                              /* ForEachC */
                                              /*----------*/
  {
    char * _D;
    printf( "ForEachC\n");
    ForEachC( _D, char, S)
      printf( "printf: %s\n", _D);
  }
  Pause();
/*--------------------------------------------------------*/
                                                  /* Save */
                                                  /*------*/
  SetSave( S, D[ 0], N/2);
  printf( "Save %s at position %d\n", D[ 0], N/2);
  printf( "ReadNext: %s\n", SetReadNext( S));
  printf( "List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
                                                /* Remove */
                                                /*--------*/
  SetRemove( S, D[ 0]);
  SetRemove( S, D[ N/2]);
  printf( "Remove %s and %s\n", D[ 0], D[ N/2]);
  printf( "List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
                                              /* SaveLast */
                                              /*----------*/
  printf( "Clear\n");
  SetClear( S);
  for( i= 0; i< N; i++) SetSaveLast( S, D[ i]);
  printf( "Save Last and List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
                                                  /* Rank */
                                                  /*------*/
  SetRank( S, strcmp);
  printf( "Rank and List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
                                            /* Find & Get */
                                            /*------------*/
  printf( "Find %s at position %d\n",
          D[ 1],
          SetFind( S, D[ 1]));
  printf( "ReadNext : %s\n", SetReadNext( S));
  printf( "Get %d'th : %s\n", N/2, SetGet( S, N/2));
  printf( "Find %s at position %d\n\n",
	     D[ 1],
          SetFind( S, D[ 1]));

  printf( "Get First: %s\n", SetGetFirst( S));
  printf( "Get Last : %s\n", SetGetLast( S));
  printf( "List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
                                            /* SaveRanked */
                                            /*------------*/
  printf( "Clear\n");
  SetClear( S);
  for( i= 0; i< N; i++) SetSaveRanked( S, D[ i], strcmp);
  printf( "SaveRanked and List:\n");
  SetList( S, PrintD);
  Pause();

/*--------------------------------------------------------*/
#ifndef __cplusplus
  printf( "\nDeliberate Set Error");
  SetList( NULL, PrintD);
#endif
}
/*--------------------------------------------------------*/
int PrintD( char *D)
{
  printf( "%s\n", D);
  return( 0);
}
/*--------------------------------------------------------*/
void Pause( void)
{
  printf( "\nPress Any Key to Continue\n");
  getch();
}
/*--------------------------------------------------------*/
