/*===========================================================================*\
| TIMERD12.C                                                ver 2.1, 07-06-89 |
|                                                                             |
| DOS event timer                                                             |
| by James H. LeMay                                                           |
| Conversion to Turbo C by Jordan Gallagher / Wisdom Research                 |
|                                                                             |
| A 24 hour timer with resolution of 1/18.2... seconds to measure elapsed     |
| time in seconds.  Works on all IBM compatible machines.                     |
|                                                                             |
| TO USE:  Place "timer( T_START );"  and  "timer( T_STOP );"  as             |
|          desired in your program.  The global variable elapsed_time         |
|          gives the result in seconds.                                       |
\*===========================================================================*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>

#include "qwikc21.h"

float ticks_per_day = 1573040.0;             /* DOS timer ticks/day. */
float ticks_per_sec = 18.2;                  /* equal to CLK_TCK in time.h */
float elapsed_time;
long t1, t2;

#define T_START 1
#define T_STOP 0

#ifdef __TURBOC__
#define tclock() (*(long far *)0x0040006CL)
#else
#define tclock() (*(long far *)(0x46CL+_z))
#endif

/*********************************| timer |**********************************\
Called to start or stop the timer.
\****************************************************************************/
void timer( int ss )
{
    switch(ss) {
        case T_START:
            elapsed_time = 0;      /* in case they reference before T_STOP */
            t1=tclock(); break;

        case T_STOP:
            t2=tclock();
            if(t2<t1) t2 += ticks_per_day;
            elapsed_time = (t2-t1) / ticks_per_sec; break;
    }
}

/*
char ch;

main()
{
    clrscr();
    printf( "Press any key for a lap; <ESC> to stop.\n" );

    timer( T_START );

    do {
        ch=getch();
        timer( T_STOP );
        printf( "time = %10.2f secs: ticks2=%ld\n", elapsed_time, t2 );
        gotoxy( 24, wherey() );
        printf( "-ticks1=%ld\n", t1 );
        gotoxy( 21, wherey() );
        printf( "time ticks=%ld\n\n", (t2-t1) );
    } while(ch != 27);

    return;
}
*/
