;;Special Header for my source files

;;must place an _endseg at the end of all my files now

.386
.387

ifdef __TASM__
  include __tasm.inc
endif

ifdef __MASM__
  include __masm.inc
endif

ifdef __WASM__
  include __wasm.inc
endif

option language:c
option dotname
option nokeyword:<.code .data .data? .stack>

ifdef _QLIB_C0_ASM_
  include src\segs.inc
endif

ifndef _QLIB_ALIGN_
  _QLIB_ALIGN_ equ <DWORD>
endif

_TEXT segment dword public use32 'CODE'
_TEXT ends
_DATA segment dword public use32 'DATA'
_DATA ends
_BSS segment dword public use32 'BSS'
_BSS ends
_STACK segment dword stack use32 'STACK'
_STACK ends

_endseg macro
  ifnb @CurSeg
    @CurSeg ends
  endif
endm

_joinstr macro s1,s2
  EXITM s1&&s2
endm

.code macro
  local _filename
  _endseg
  _filename textequ _joinstr <@FileName>,<_TEXT>
  DGROUP group _TEXT,_filename
  _filename segment _QLIB_ALIGN_ public use32 'CODE'
endm

.data macro
  local _filename
  _endseg
  _filename textequ _joinstr <@FileName>,<_DATA>
  DGROUP group _DATA,_filename
  _filename segment _QLIB_ALIGN_ public use32 'DATA'
endm

.data? macro
  local _filename
  _endseg
  _filename textequ _joinstr <@FileName>,<_BSS>
  DGROUP group _BSS,_filename
  _filename segment _QLIB_ALIGN_ public use32 'BSS'
endm

.stack macro
  _endseg
  DGROUP group _STACK
  _STACK segment dword stack use32 'STACK'
endm

.bss macro
  .data?
endm

.init macro
  _endseg
  _INIT_ segment word public use32 'INITDATA'
endm

.uninit macro
  _endseg
  _EXIT_ segment word public use32 'EXITDATA'
endm

assume ds:flat,es:flat,ss:flat,fs:flat,gs:flat
    ; by default FS: and GS: are assumed to ERROR

;;include_pasm_strings;;  ;used by PASM for strings within ASM code (v2.00)

include stddef.inc

ifndef _DLL_CODE_
  include qlib_def.inc
endif

include callp.inc

include src\opt1.inc

externdef __qlib_errors:DWORD

ERROR_Cantgetbase equ 0*4
ERROR_Cantsetint  equ 1*4
ERROR_Cantgetint  equ 2*4
ERROR_Cantgetcb   equ 3*4

