#ifndef __MATH_H__
#define __MATH_H__

#include <stddef.h>

#define HUGE_VAL _HugeValue

//constants (21 decimals)
#define M_E	    	2.71828182845904523536
#define M_LOG2E		1.44269504088896340736
#define M_LOG10E	0.434294481903251827651
#define M_LN2		0.693147180559945309417
#define M_LN10		2.30258509299404568402
#define M_PI		3.14159265358979323846
#define M_PI_2		1.57079632679489661923
#define M_PI_4		0.785398163397448309616
#define M_1_PI		0.318309886183790671538
#define M_2_PI		0.636619772367581343076
#define M_1_SQRTPI	0.564189583547756286948
#define M_2_SQRTPI	1.12837916709551257390
#define M_SQRT2		1.41421356237309504880
#define M_SQRT_2	0.707106781186547524401

#ifdef __cplusplus
  extern "C" {
#endif

extern double _HugeValue;

extern double sin(double a);
extern double cos(double a);
extern double tan(double a);
extern dword ftol(double a);
extern double ftoa(double,void *,dword);
extern double f_abs(double);
extern double ceil(double);
extern double floor(double);
extern double atof(char *a);

extern double exp(double);
extern double log(double);
extern double log2(double);
extern double log10(double);
extern double pow(double,double);
extern double pow10(double);
extern double sqrt(double);

#ifdef __cplusplus
  }
#endif

#define fabs f_abs

#endif

