/***********************************************************/
/* File Id.                  Wtitle.C                      */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/13/88.                     */
/* Modifications.                                          */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Comments:  This routine will title a window.            */
/***********************************************************/

#include <stdio.h>
#include <string.h>
#include "pcw.i"
#include "pcwproto.h"

#define  TRUE   1
#define  FALSE  0

static int titlefclr = LIGHTGRAY;
static int titlebclr = BLACK;

int wtitle(WNDPTR *wnd, int tb, int lrm, char *s) {

    int page;
    int col, row;
    int mx_rows, mx_cols;

    if (!chk_video_state(&mx_rows, &mx_cols)) return(0);
    if (wnd == NULL) return(0);
    if (wnd->hideflag) return(1);                    /* Return if hidden */

    re_order(wnd, NORMAL);
    if (strlen(s) > ((wnd->lcol - wnd->ucol) - 2))
       return(FALSE);

    switch(tb) {
        case TOP    : row = wnd->urow; break;
        case BOTTOM : row = wnd->lrow; break;
        default     : row = wnd->urow; break;
    }

    switch(lrm) {
        case LEFT   : col = wnd->ucol + 2; break;
        case RITE   : col = (wnd->lcol - strlen(s)) - 1; break;
        default     :
        case MIDDLE : col = (wnd->lcol + wnd->ucol) / 2;
                      col = col - (strlen(s) / 2);
                      break;
    }

    page = getpage();                              /* Save current page */
    setpage(wnd->page);                            /* Set for window page */
    qputs(row,col,titlefclr,titlebclr,s);          /* Write the title */
    setpage(page);                                 /* Restore current page */
    return(TRUE);                                  /* and quit */
}

/***********************************************************/
/*                       TITLECOLOR()                      */
/*                                                         */
/* This function changes the value of the two static       */
/* variables which determine the title color when wtitle is*/
/* called.                                                 */
/***********************************************************/

void titlecolor(int fcolor, int bcolor) {

     titlefclr = (fcolor & 0x000f);
     titlebclr = (bcolor & 0x000f);
}

