/*===================================================================
 interpol.h

 Version 1.0

 Written by:
   Brent Worden
   WordenWare
   email:  brent@worden.org

 Copyright (c) 2000-2001 WordenWare

 Created:  January 7, 2000
 Revised:  
===================================================================*/

#ifndef _INTERPOL_H_
#define _INTERPOL_H_

#include "numerics.h"

NUMERICS_EXPORT double polyint(double *xa, double *ya, int n, double x, double *dy);
/*-------------------------------------------------------------------
 For a function f whose values at the points xa[0..n-1] are
 ya[0..n-1], this routine approximates f with a n-1 degree polynomial
 and returns the interpolated value at the point x.  On return, dy
 contains an error estimate.
-------------------------------------------------------------------*/

#endif

/*===================================================================
 Revision History

 Version 1.0 - 01/07/2000 - New.
===================================================================*/
