/* yd_dot.h                     freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction innerprod(
pmatrix mu,
pmatrix mv
)
{
fraction InnerProduct;

  if (mu->rows == 1                 &&
      mu->cols == mv->rows * TWOCOL &&
      mv->cols == TWOCOL
     )
     {
      InnerProduct = innerprod_uDotv_uv(mu,mv);
     }
    else if
     (mu->rows == 1        &&
      mv->rows == 1        &&
      mu->cols == mv->cols
     )
     {
      InnerProduct = innerprod_uDotv_uvT(mu,mv);
     }
    else if
     (mu->rows == mv->rows &&
      mu->cols == mv->cols &&
      mu->cols == TWOCOL
     )
     {
      InnerProduct = innerprod_uDotv_vTu(mu,mv);
     }
    else if
     (mu->rows * TWOCOL == mv->cols &&
      mu->cols          == TWOCOL   &&
      mv->rows          == 1
     )
     {
      InnerProduct = innerprod_uDotv_vu(mu,mv);
     }
     else
     {
      printf(" innerprod() error.\n\n");

      printf("\nPress Return to continue\n");
      getchar();
      exit(1);
     }


  return(InnerProduct);
}



/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction normP2(
pmatrix mu
)
{
fraction NormP2;

         NormP2 = innerprod(mu,mu);

  return(NormP2);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction distanceP2(
pmatrix mu,
pmatrix mv
)
{
fraction DistanceP2;

double pu_mns_v [MXR][MXC*TWOCOL];
matrix mu_mns_v={MXR, MXC*TWOCOL,&pu_mns_v[0][0]};

       mu_mns_v.rows = mu->rows;
       mu_mns_v.cols = mu->cols;

      submF(mu,mv,&mu_mns_v);

  DistanceP2 = normP2(&mu_mns_v);

  return(DistanceP2);
}


