/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
int p = n + 1;
int m = n - 1;

double pbA    [mxr][mxc    *TWOCOL]; matrix mA     ={mxr,mxc    *TWOCOL,&pbA    [0][0]};
double pbInvA [mxr][mxc    *TWOCOL]; matrix mInvA  ={mxr,mxc    *TWOCOL,&pbInvA [0][0]};
double pbb1   [mxr][        TWOCOL]; matrix mb1    ={mxr,        TWOCOL,&pbb1   [0][0]};
double pbb2   [mxr][        TWOCOL]; matrix mb2    ={mxr,        TWOCOL,&pbb2   [0][0]};
double pbb3   [mxr][        TWOCOL]; matrix mb3    ={mxr,        TWOCOL,&pbb3   [0][0]};
double pbA_b1 [mxr][(mxc+1)*TWOCOL]; matrix mA_b1  ={mxr,(mxc+1)*TWOCOL,&pbA_b1 [0][0]};
double pbA_b2 [mxr][(mxc+1)*TWOCOL]; matrix mA_b2  ={mxr,(mxc+1)*TWOCOL,&pbA_b2 [0][0]};
double pbA_b3 [mxr][(mxc+1)*TWOCOL]; matrix mA_b3  ={mxr,(mxc+1)*TWOCOL,&pbA_b3 [0][0]};
double pbb_n  [mxr][3      *TWOCOL]; matrix mb_n   ={mxr,3      *TWOCOL,&pbb_n  [0][0]};
double pTb_n  [mxr][3      *TWOCOL]; matrix mTb_n  ={mxr,3      *TWOCOL,&pTb_n  [0][0]};
double pbT1   [mxr][mxc    *TWOCOL]; matrix mT1    ={mxr,mxc    *TWOCOL,&pbT1   [0][0]};
double pbT2   [mxr][mxc    *TWOCOL]; matrix mT2    ={mxr,mxc    *TWOCOL,&pbT2   [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                  mInvA.rows=n;                mInvA.cols=n*TWOCOL;
                    mb1.rows=n;                  mb1.cols=  TWOCOL;
                    mb2.rows=n;                  mb2.cols=  TWOCOL;
                    mb3.rows=n;                  mb3.cols=  TWOCOL;
                  mA_b1.rows=n;                mA_b1.cols=p*TWOCOL;
                  mA_b2.rows=n;                mA_b2.cols=p*TWOCOL;
                  mA_b3.rows=n;                mA_b3.cols=p*TWOCOL;
                   mb_n.rows=n;                 mb_n.cols=3*TWOCOL;
                  mTb_n.rows=n;                mTb_n.cols=3*TWOCOL;
                    mT1.rows=m;                  mT1.cols=m*TWOCOL;
                    mT2.rows=n;                  mT2.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 25;}

  randmI(&mA, x);
  randmI(&mb1,x);
  randmI(&mb2,x);
  randmI(&mb3,x);

  copymF(  &mA,   &mA_b1  );
  copycolF(&mb1,0,&mA_b1,n);
  copymF(  &mA,   &mA_b2  );
  copycolF(&mb2,0,&mA_b2,n);
  copymF(  &mA,   &mA_b3  );
  copycolF(&mb3,0,&mA_b3,n);
  copycolF(&mb1,0,&mb_n,0);
  copycolF(&mb2,0,&mb_n,1);
  copycolF(&mb3,0,&mb_n,2);

  clrscrn();
  printf("\n Solving linear systems by matrix inversion : Ax = b1|b2|b3\n");
  printf("\n A :\n");
  printmI(&mA);
  getchar();

  clrscrn();
  printf("\n b1 :\n");
  printmI(&mb1);
  printf("\n b2 :\n");
  printmI(&mb2);
  printf("\n b3 :\n");
  printmI(&mb3);
  getchar();

  clrscrn();
  printf("\n                                    Inv(A) :\n");
  inverseF(&mA,&mT1,&mT2,&mInvA);
  printmF (              &mInvA);
  printf("\n                                  b1|b2|b3 :\n");
  printmI(&mb_n);
  printf("\n      Ax = b1|b2|b3 => x = Inv(A)*b1|b2|b3 :\n");
  multmF(&mInvA,&mb_n,&mTb_n);
  printmF(              &mTb_n);
  getchar();

  clrscrn();
  printf("\n                    x = Inv(A)*b1|b2|b3 :\n");
  printmI(&mTb_n);
  printf("\n                                   A|b1 :\n");
  printmF(&mA_b1);
  gaussjordanF(&mA_b1);
  printf("\n        Verify with GaussJordan on A|b1 :\n");
  printmIF(&mA_b1);
  getchar();

  clrscrn();
  printf("\n                    x = Inv(A)*b1|b2|b3 :\n");
  printmF(&mTb_n);
  printf("\n                                   A|b2 :\n");
  printmI(&mA_b2);
  gaussjordanF(&mA_b2);
  printf("\n        Verify with GaussJordan on A|b2 :\n");
  printmIF(&mA_b2);
  getchar();

  clrscrn();
  printf("\n                    x = Inv(A)*b1|b2|b3 :\n");
  printmF(&mTb_n);
  printf("\n                                   A|b3 :\n");
  printmI(&mA_b3);
  gaussjordanF(&mA_b3);
  printf("\n        Verify with GaussJordan on A|b3 :\n");
  printmIF(&mA_b3);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n     Ax = b1|b2|b3 => x = Inv(A)*b1|b2|b3         ");
  printf("\n     ************************************       \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"invz3i.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invz3i.exe 2\" -> mA 2x2        ");
  printf("\n                \"invz3i.exe 3\" -> mA 3x3        ");
  printf("\n                \"invz3i.exe 4\" -> mA 4x4        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n> mxr){n=mxr;}
    }
  else
    {
    n = (int) fabs(randF(mxr));
    }

    if(n<2){n=2;}

  invb(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

