/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
int m = n + 4;
int p = n + 1;

double pbA    [n][n*TWOCOL]; matrix mA    ={n,n*TWOCOL,&pbA   [0][0]};
double pbb1   [n][  TWOCOL]; matrix mb1   ={n,  TWOCOL,&pbb1  [0][0]};
double pbb2   [n][  TWOCOL]; matrix mb2   ={n,  TWOCOL,&pbb2  [0][0]};
double pbb3   [n][  TWOCOL]; matrix mb3   ={n,  TWOCOL,&pbb3  [0][0]};
double pbb4   [n][  TWOCOL]; matrix mb4   ={n,  TWOCOL,&pbb4  [0][0]};
double pbA_bn [n][m*TWOCOL]; matrix mA_bn ={n,m*TWOCOL,&pbA_bn[0][0]};
double pbA_b1 [n][p*TWOCOL]; matrix mA_b1 ={n,p*TWOCOL,&pbA_b1[0][0]};
double pbA_b2 [n][p*TWOCOL]; matrix mA_b2 ={n,p*TWOCOL,&pbA_b2[0][0]};
double pbA_b3 [n][p*TWOCOL]; matrix mA_b3 ={n,p*TWOCOL,&pbA_b3[0][0]};
double pbA_b4 [n][p*TWOCOL]; matrix mA_b4 ={n,p*TWOCOL,&pbA_b4[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 10;}

  randmI(&mA, x);
  randmI(&mb1,x);
  randmI(&mb2,x);
  randmI(&mb3,x);
  randmI(&mb4,x);

  copymF(&mA, &mA_b1 );  copycolF(&mb1,0,&mA_b1,n  );
  copymF(&mA, &mA_b2 );  copycolF(&mb2,0,&mA_b2,n  );
  copymF(&mA, &mA_b3 );  copycolF(&mb3,0,&mA_b3,n  );
  copymF(&mA, &mA_b4 );  copycolF(&mb4,0,&mA_b4,n  );
  copymF(&mA, &mA_bn );  copycolF(&mb1,0,&mA_bn,n  );
                         copycolF(&mb2,0,&mA_bn,n+1);
                         copycolF(&mb3,0,&mA_bn,n+2);
                         copycolF(&mb4,0,&mA_bn,n+3);
  clrscrn();
  printf("\n Linear systems with a common coefficient matrix :");
  printf(" Ax = A|b1|b2|b3|b4 \n");
  printf("\n                                              A  :\n");
  printmI(&mA);
  printf("\n                                              b1 :\n");
  printmI(&mb1);
  getchar();

  clrscrn();
  printf("\n                                              b2 :\n");
  printmI(&mb2);
  printf("\n                                              b3 :\n");
  printmI(&mb3);
  printf("\n                                              b4 :\n");
  printmI(&mb4);
  getchar();

  clrscrn();
  printf("\n                                   A|b1|b2|b3|b4 :\n");
  printmI(    &mA_bn);
  gaussjordanF(&mA_bn);
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printm4IF(    &mA_bn);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printm4IF(    &mA_bn);
  printf("\n                                            A|b1 :\n");
  printmI(    &mA_b1);
  printf("\n         Gauss Jordan elimination of matrix A|b1 :\n");
  gaussjordanF(&mA_b1);
  printmIF(    &mA_b1);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printm4IF(    &mA_bn);
  printf("\n                                            A|b2 :\n");
  printmI(    &mA_b2);
  printf("\n         Gauss Jordan elimination of matrix A|b2 :\n");
  gaussjordanF(&mA_b2);
  printmIF(    &mA_b2);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printm4IF(    &mA_bn);
  printf("\n                                            A|b3 :\n");
  printmI(    &mA_b3);
  printf("\n         Gauss Jordan elimination of matrix A|b3 :\n");
  gaussjordanF(&mA_b3);
  printmIF(    &mA_b3);
  getchar();

  clrscrn();
  printf("\nGauss Jordan elimination of matrix A|b1|b2|b3|b4 :\n");
  printm4IF(    &mA_bn);
  printf("\n                                            A|b4 :\n");
  printmI(    &mA_b4);
  printf("\n         Gauss Jordan elimination of matrix A|b4 :\n");
  gaussjordanF(&mA_b4);
  printmIF(    &mA_b4);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            GaussJordan : A|b1|b2|b3|b4           ");
  printf("\n            ***************************         \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"gausx4f.exe\"                 \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"gausx4f.exe 2\" -> mA 2x2       ");
  printf("\n                \"gausx4f.exe 3\" -> mA 3x3       ");
  printf("\n                \"gausx4f.exe 4\" -> mA 4x4       ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invb(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

