/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invAB(int n)
{
int  x;
int pn;

double pbA      [MXR][MXC*TWOCOL];    matrix mA      ={MXR,MXC*TWOCOL,&pbA       [0][0]};
double pbinvA   [MXR][MXC*TWOCOL];    matrix minvA   ={MXR,MXC*TWOCOL,&pbinvA    [0][0]};
double pbApn    [MXR][MXC*TWOCOL];    matrix mApn    ={MXR,MXC*TWOCOL,&pbApn     [0][0]};
double pbinvApn [MXR][MXC*TWOCOL];    matrix minvApn ={MXR,MXC*TWOCOL,&pbinvApn  [0][0]};
double pbinvA_pn[MXR][MXC*TWOCOL];    matrix minvA_pn={MXR,MXC*TWOCOL,&pbinvA_pn [0][0]};

double pinvApn_mns_invA_pn [MXR][MXC*TWOCOL];
matrix minvApn_mns_invA_pn={MXR, MXC*TWOCOL,&pinvApn_mns_invA_pn[0][0]};

                     mA.rows=n;                  mA.cols=n*TWOCOL;
                  minvA.rows=n;               minvA.cols=n*TWOCOL;
                   mApn.rows=n;                mApn.cols=n*TWOCOL;
                minvApn.rows=n;             minvApn.cols=n*TWOCOL;
               minvA_pn.rows=n;            minvA_pn.cols=n*TWOCOL;
    minvApn_mns_invA_pn.rows=n;  minvApn_mns_invA_pn.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */

           x = 9;
 if(n==3){ x = 5; }

 rndmF(&mA,x,1);

  pn = rndp0I(4);

  if(n==3 && pn==4){pn=2;}

 clrscrn();
 printf("                                                        A :\n");
 printmF(&mA);
 printf("                                                    A**%d :\n",pn);
 powermF(&mA,&mApn,pn);
 printmF(    &mApn);
 printf("                                           inverse(A**%d) :\n",pn);
 inv_xhunga(&mApn,&minvApn);
 printmF(         &minvApn);
 getchar();

/* invA */
 clrscrn();
 printf("                                                        A :\n");
 printmF(&mA);
 printf("                                              inverse(A)  :\n");
 inv_xhunga(&mA,&minvA);
 printmF(       &minvA);

 printf("                                         (inverse(A))**%d :\n",pn);
 powermF(&minvA,&minvA_pn,pn);
 printmF(       &minvA_pn);
 getchar();

 clrscrn();
 printf("                                           inverse(A**%d) :\n",pn);
 printmF(&minvApn);
 printf("                                         (inverse(A))**%d :\n",pn);
 printmF(&minvA_pn);
 submF(&minvApn,&minvA_pn,&minvApn_mns_invA_pn);
 printf("                        inverse(A**%d) - (inverse(A))**%d :\n",pn,pn);
 printmF(&minvApn_mns_invA_pn);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n        inverse(A**n) = inverse(A)**n             ");
  printf("\n        *****************************           \n");
  printf("\n The size of mA : 2x2 ... 3x3.                  \n");
  printf("\n           ex : \"invanf.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invanf.exe 2\" -> mA 2x2        ");
  printf("\n                \"invanf.exe 3\" -> mA 3x3        ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]) )
 {n = atoi(argv[1]); if( n > 3){n=3;} }
else
 {    n=rndpI(3);  }
   if(n<2){n=2;}


  invAB(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

