/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invB(int n,int p)
{
fraction k;

double pbA      [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA      [0][0]};
double pbkA     [MXR][MXC*TWOCOL];matrix mkA     ={MXR,MXC*TWOCOL,&pbkA     [0][0]};
double pbTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA  ={MXR,MXC*TWOCOL,&pbTrpsA  [0][0]};
double pbTrpskA [MXR][MXC*TWOCOL];matrix mTrpskA ={MXR,MXC*TWOCOL,&pbTrpskA [0][0]};
double pbk_TrpsA[MXR][MXC*TWOCOL];matrix mk_TrpsA={MXR,MXC*TWOCOL,&pbk_TrpsA[0][0]};

double pbTrpskA_mns_k_TrpsA[MXR][MXC*TWOCOL];
matrix mTrpskA_mns_k_TrpsA={MXR, MXC*TWOCOL,&pbTrpskA_mns_k_TrpsA[0][0]};

                     mA.rows=n;                   mA.cols=p*TWOCOL;
                    mkA.rows=n;                  mkA.cols=p*TWOCOL;
                 mTrpsA.rows=p;               mTrpsA.cols=n*TWOCOL;
                mTrpskA.rows=p;              mTrpskA.cols=n*TWOCOL;
              mk_TrpsA.rows=p;              mk_TrpsA.cols=n*TWOCOL;

      mTrpskA_mns_k_TrpsA.rows=p;      mTrpskA_mns_k_TrpsA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */

 k = rndF(9,4);

 rndmF(&mA,9,4);

 clrscrn();
 printf(" %6.0f/%.0f",k.numer,k.denom);
 printf("                                                k :\n\n");
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                                        kA :\n");
 smultmF(k,&mA,&mkA);
 printmF(&mkA);
 printf("                                             transpose(kA) :\n");
 transposemF(&mkA,&mTrpskA);
 printmF(        &mTrpskA);
 getchar();


 clrscrn();
 printf(" %6.0f/%.0f",k.numer,k.denom);
 printf("                                                k :\n\n");
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                              transpose(A) :\n");
 transposemF(&mA,&mTrpsA);
 printmF(       &mTrpsA);
 printf("                                            k transpose(A) :\n");
 smultmF(k,&mTrpsA,&mk_TrpsA);
 printmF(          &mk_TrpsA);
 getchar();

 clrscrn();
 printf("                                             transpose(kA) :\n");
 printmF(&mTrpskA);
 printf("                                            k transpose(A) :\n");
 printmF(&mk_TrpsA);
 printf("                          transpose(kA) - (k transpose(A)) :\n");
 submF(&mTrpskA,&mk_TrpsA,&mTrpskA_mns_k_TrpsA);
 printmF(&mTrpskA_mns_k_TrpsA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n          transpose(kA) - (k transpose(A))        ");
  printf("\n          ********************************      \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpdf.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpdf.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpdf.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpdf.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 3 && atoi(argv[1]) && atoi(argv[2]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;} }
else
 {    n=rndpI(5);   p=rndpI(5);  }
   if(n<2){n=2;} if(p<2){p=2;}


  invB(n,p);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

