/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
double pbA     [mxr][mxc*TWOCOL];matrix mA      ={mxr,mxc*TWOCOL,&pbA     [0][0]};
double pbB     [mxr][mxc*TWOCOL];matrix mB      ={mxr,mxc*TWOCOL,&pbB     [0][0]};
double pbAB    [mxr][mxc*TWOCOL];matrix mAB     ={mxr,mxc*TWOCOL,&pbAB    [0][0]};
double pTrpsA  [mxr][mxc*TWOCOL];matrix mTrpsA  ={mxr,mxc*TWOCOL,&pTrpsA  [0][0]};
double pTrpsB  [mxr][mxc*TWOCOL];matrix mTrpsB  ={mxr,mxc*TWOCOL,&pTrpsB  [0][0]};
double pTrps_AB[mxr][mxc*TWOCOL];matrix mTrps_AB={mxr,mxc*TWOCOL,&pTrps_AB[0][0]};

double pTrpsBTrpsA [mxr][mxc*TWOCOL];
matrix mTrpsBTrpsA={mxr, mxc*TWOCOL,&pTrpsBTrpsA[0][0]};

double pTrps_AB_mns_TrpsBTrpsA [mxr][mxc*TWOCOL];
matrix mTrps_AB_mns_TrpsBTrpsA={mxr, mxc*TWOCOL,&pTrps_AB_mns_TrpsBTrpsA[0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
                     mB.rows=n;                   mB.cols=n*TWOCOL;
                    mAB.rows=n;                  mAB.cols=n*TWOCOL;
                 mTrpsA.rows=n;               mTrpsA.cols=n*TWOCOL;
                 mTrpsB.rows=n;               mTrpsB.cols=n*TWOCOL;
               mTrps_AB.rows=n;             mTrps_AB.cols=n*TWOCOL;
            mTrpsBTrpsA.rows=n;          mTrpsBTrpsA.cols=n*TWOCOL;

     mTrps_AB_mns_TrpsBTrpsA.rows=n;   mTrps_AB_mns_TrpsBTrpsA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
 randmI(&mA,9);
 randmI(&mB,9);

 clrscrn();
 printf("                                                         A :\n");
 printmI(&mA);
 printf("                                                         B :\n");
 printmI(&mB);
 printf("                                                        AB :\n");
 multmF(&mA,&mB,&mAB);
 printmI(       &mAB);
 getchar();

 clrscrn();
 printf("                                                       AB  :\n");
 printmI(   &mAB);
 printf("                                             transpose(AB) :\n");
 transposeF(&mAB,&mTrps_AB);
 printmI(        &mTrps_AB);
 getchar();

 clrscrn();
 printf("                                                        A  :\n");
 printmI(&mA);
 printf("                                              transpose(A) :\n");
 transposeF(&mA,&mTrpsA);
 printmI(       &mTrpsA);
 getchar();

 clrscrn();
 printf("                                                        B  :\n");
 printmI(&mB);
 printf("                                              transpose(B) :\n");
 transposeF(&mB,&mTrpsB);
 printmI(       &mTrpsB);
 getchar();


 clrscrn();
 printf("                                              transpose(B) :\n");
 printmI(&mTrpsB);
 printf("                                              transpose(A) :\n");
 printmI(&mTrpsA);
 printf("                               transpose(B) * transpose(A) :\n");
 multmF(&mTrpsB,&mTrpsA,&mTrpsBTrpsA);
 printmI(&mTrpsBTrpsA);
 getchar();

 clrscrn();
 printf("                                             transpose(AB) :\n");
 printmI(           &mTrps_AB);
 printf("                               transpose(B) * transpose(A) :\n");
 printmI(&mTrpsBTrpsA);
 printf("             transpose(AB) - (transpose(B) * transpose(A)) :\n");
 submF(&mTrps_AB,&mTrpsBTrpsA, &mTrps_AB_mns_TrpsBTrpsA);
 printmI(&mTrps_AB_mns_TrpsBTrpsA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  transpose(AB) = (transpose(B) * transpose(A))   ");
  printf("\n  ********************************************  \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpei.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpei.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpei.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpei.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);

    if( n> mxr){n=mxr;}
    }
  else
    {
    n = (int) fabs(randF(mxr));

    }

    if( n< 2){n=2;}

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

