/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
cofac(int n)
{
int      row;
int      col;
fraction f;

double pbA    [MXR][MXC*TWOCOL];  matrix mA   = {MXR,MXC*TWOCOL,&pbA    [0][0]};

                     mA.rows=n;                   mA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmF(&mA,9,9);
  row = rndp0I(n);         /* c   */
  col = rndp0I(n);

  clrscrn();
  printf("                                                       A :");
  printmF(&mA);

  f = cofactorF(&mA, row, col);
  printf("\n\n cofactor of entry A(%d,%d) %.0f/%.0f \n",
          row+1,  /* math */
          col+1,
          f.numer,
          f.denom);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            Find a cofactor of mA                 ");
  printf("\n            *********************               \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"cofacf.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"cofacf.exe 2\" -> mA 2x2        ");
  printf("\n                \"cofacf.exe 3\" -> mA 3x3        ");
  printf("\n                \"cofacf.exe 4\" -> mA 4x4        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 2){n=2;}


  cofac(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}



