/* transpose.c                       freeware                  xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblockA[2][4*TWOCOL]=
{
0,0, 0,1, 0,2, 0,3,
1,0, 1,1, 1,2, 1,3,
};
matrix mA={2,4*TWOCOL,&pblockA[0][0]};

double pblockB[4][2*TWOCOL];
matrix  mB =  {4, 2*TWOCOL,&pblockB[0][0]};


/*-------------------------------- PROGRAM ---------------------------------- */
  printf("\n\nMatrix A\n");
  printmF(&mA);

  printf("\n\n\nTranspose of matrix A\n");
  transposeF(&mA, &mB);
  printmF(        &mB);

 printf("\n Press a key to continue");
 getchar();
}








