/* Copyright 1996  Jonathan Griffiths. See "readme.jon" for detailed terms. */
#ifndef __JX_FONT_H__              
#define __JX_FONT_H__ 1 

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>
#include <jlib.h>

/* font data type */
typedef struct{
     UBYTE magic;               
     UBYTE proportional;
     UBYTE width;
     UBYTE height;
     UBYTE underline;
     UBYTE first_char;
     UBYTE last_char;
     UBYTE color;                  /* color font? (not implemented yet) */
     UBYTE reserved;               /* NOT for application use */
     UBYTE *palette;
     sprite_system *font_data;
}font;

#define FONT_IS_PROPORTIONAL(fptr) ((fptr)->proportional)
#define FONT_WIDTH(fptr)           ((fptr)->width)
#define FONT_HEIGHT(fptr)          ((fptr)->height)
#define FONT_FIRST_CHAR(fptr)      ((fptr)->first_char)
#define FONT_LAST_CHAR(fptr)       ((fptr)->last_char)
#define FONT_HAS_CHAR(fptr,c)      ((c>=fptr->first_char)&&(c<=fptr->last_char))
#define FONT_MAGIC                 113   /* font file magic number */

/* font drawing options */
#define FONT_STAMP      1
#define FONT_TEXTURE    2
#define FONT_UNDERLINE  4

/* for ease of reading */
#define BR buffer_rec

font *font_load(char *filename);
font *font_free(font *font);

int  font_letter_height(font *fnt,char c);
int  font_letter_width(font *fnt,char c);
int  font_string_width(font *fnt,char *c);


void font_charNC(font *fnt,BR *dst,int x,int y,char c,UBYTE col,BR *src,int style);
void font_char(font *fnt,BR *dst,int x,int y,char c,UBYTE col,BR *src,int style);

void font_stringNC(font *fnt,BR *dst,int x,int y,char *s,UBYTE col,BR *src,int style);
void font_string(font *fnt,BR *dst,int x,int y,char *s,UBYTE col,BR *src,int style);


/* the following functions are obsolete: use the functions above instead */

#define font_stamp_letterNC(f,b,x,y,c,col) \
font_charNC(f,b,x,y,c,col,NULL,FONT_STAMP);

#define font_stamp_letter(f,b,x,y,c,col) \
font_char(f,b,x,y,c,col,NULL,FONT_STAMP);

#define font_stamp_underline_letterNC(f,b,x,y,c,col) \
font_charNC(f,b,x,y,c,col,NULL,FONT_STAMP|FONT_UNDERLINE);

#define font_stamp_underline_letter(f,b,x,y,c,col) \
font_char(f,b,x,y,c,col,NULL,FONT_STAMP|FONT_UNDERLINE);

#define font_stamp_stringNC(f,b,x,y,s,col) \
font_stringNC(f,b,x,y,s,col,NULL,FONT_STAMP);

#define font_stamp_string(f,b,x,y,s,col) \
font_string(f,b,x,y,s,col,NULL,FONT_STAMP);

#define font_stamp_underline_stringNC(f,b,x,y,s,col) \
font_stringNC(f,b,x,y,s,col,NULL,FONT_STAMP|FONT_UNDERLINE);

#define font_stamp_underline_string(f,b,x,y,s,col) \
font_string(f,b,x,y,s,col,NULL,FONT_STAMP|FONT_UNDERLINE);

#define font_stencil_letterNC(f,b,x,y,c,col) \
font_charNC(f,b,x,y,c,col,NULL,0);

#define font_stencil_letter(f,b,x,y,c,col) \
font_char(f,b,x,y,c,col,NULL,0);

#define font_stencil_underline_letterNC(f,b,x,y,c,col) \
font_charNC(f,b,x,y,c,col,NULL,FONT_UNDERLINE);

#define font_stencil_underline_letter(f,b,x,y,c,col) \
font_char(f,b,x,y,c,col,NULL,FONT_UNDERLINE);

#define font_stencil_stringNC(f,b,x,y,s,col) \
font_stringNC(f,b,x,y,s,col,NULL,0);

#define font_stencil_string(f,b,x,y,s,col) \
font_string(f,b,x,y,s,col,NULL,0);

#define font_stencil_underline_stringNC(f,b,x,y,s,col) \
font_stringNC(f,b,x,y,s,col,NULL,FONT_UNDERLINE);

#define font_stencil_underline_string(f,b,x,y,s,col) \
font_string(f,b,x,y,s,col,NULL,FONT_UNDERLINE);

#undef BR

#ifdef __cplusplus
}
#endif 

#endif

