/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * X Version Copyright (C) 1995 Mike Manley
 * 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>

/* some global stuff to help us manage */
Display*	jxdisplay;
int		jxscreen;
Window		jxwindow;
Colormap	jxcolormap;
GC		jxgc;
long jxmask;

char version_string[] = "X11 API";
static int __jlib_screen_initted=0;

/*+------------------------------------------------------------------------+ */
/*|set video mode.                                                         | */
/*+------------------------------------------------------------------------+ */
int screen_set_video_mode(void)
{
  /* Open X Display and create window */
  /* Note - this will currently only work on a 256 color depth 8 XServer */
	XEvent event;
	XGCValues   gcvals;
	unsigned long  gcvmask=0;

	if((jxdisplay = XOpenDisplay(NULL)) == NULL)
	{
		/* Failed - now what ? */
		return 0; /* mode set failed */
	}
	/* Get the default screen */
	jxscreen = DefaultScreen(jxdisplay);

	/* Create a Graphics Context to use for blitting */
        /* Set up graphics context - oops this is currently a memory leak */
        /* GC can probably just be created once as part of screen_set_video_mode */
	gcvals.graphics_exposures = 0;
	gcvmask = GCGraphicsExposures;
	jxgc = XCreateGC(jxdisplay, RootWindow(jxdisplay, jxscreen), gcvmask, &gcvals);

	/* and try to create a screen sized (hopefully depth 8) window on it! */
	jxwindow = XCreateSimpleWindow(jxdisplay, RootWindow(jxdisplay, jxscreen),
					0, 0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0, 0);
	/* Now try to create a colormap */
	jxcolormap = XCreateColormap(jxdisplay, jxwindow, DefaultVisual(jxdisplay, jxscreen),
					AllocAll);
	/* Set the colormap to the window */
	XSetWindowColormap(jxdisplay, jxwindow, jxcolormap);
	/* Be friendly and tell the window manager we need a colormap */
	XSetWMColormapWindows(jxdisplay, jxwindow, NULL, 0);
	/* Map the window */
	XMapWindow(jxdisplay, jxwindow);
	/* Flush the display to ensure all requests are sent */
	XFlush(jxdisplay);
	/* Finally read the event queue - we need to do this 'coz X doesn't */
	/* display our window until we do. */
	while(XCheckMaskEvent(jxdisplay, ~NoEventMask, &event));  

	__jlib_screen_initted= 1;

        /* return success */
        return 1;
}


/*+------------------------------------------------------------------------+*/
/*|close the X window and return                                           |*/
/*+------------------------------------------------------------------------+*/
void screen_restore_video_mode(void)
{
  if(__jlib_screen_initted){
	/* Destroy our window and Close X */
	XDestroyWindow(jxdisplay, jxwindow);
	XFreeGC(jxdisplay, jxgc);
	XFreeColormap(jxdisplay, jxcolormap);
	XCloseDisplay(jxdisplay);
	__jlib_screen_initted= 0;
 }
}


/*+------------------------------------------------------------------------+ */
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */
int screen_get_page (void)
{
   return 1;
}


/*+------------------------------------------------------------------------+ */
/*|set the given  page number.                                             | */
/*+------------------------------------------------------------------------+ */
void screen_set_page (int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page.                                          | */
/*+------------------------------------------------------------------------+ */
void screen_show_page (int page)
{
   /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Wait for the retrace beam to move offscreen.                            | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_wait_vsync (void)
{
   /* not implememted yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill (UBYTE color) 
{
 /* not implememted yet */	
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear (void) 
{
 /* not implememted yet */	
}


#ifndef __GNUC__            /* TO DO: implement for non gcc compilers */
void uclock_init(void)
{
}


unsigned int uclock_read(void)
{
 return 1;
}
#endif
