/****************************************************************************
 This file was based on keyboard handling code from "Allegro",  a low-level
 gaming library for djgpp V2. I have now butchered the code a *lot*.
 Allegro is authored by:

Shawn Hargreaves,
1 Salisbury Road,
Market Drayton,
Shropshire,
England TF9 1AJ
email slh100@tower.york.ac.uk (until july 1996)

 And is available by anonymous ftp from x2ftp.oulu.fi in the directory:
 /pub/msdos/programming/djgpp2

 Here is what Shawn has to say regarding copyright,  etc.. 

   4: What about copyright issues?
   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   Allegro is swap-ware. You may use, modify, redistribute, and generally 
   hack it about in any way you like, but if you do you must send me 
   something in exchange. This could be a complimentary copy of a game, an 
   addition or improvement to Allegro, a bugfix, some money (this is 
   particularly encouraged if you use Allegro in a commercial product), or 
   just a copy of your autoexec.bat if you don't have anything better. If 
   you redistribute parts of Allegro or make a game using it, it would be 
   nice if you mentioned me somewhere in the credits, but if you just want 
   to pinch a few routines that is OK too. I'll trust you not to rip me off.

  There you go,  enjoy!
****************************************************************************/
#include <stdlib.h>
#include <go32.h>
#include <dpmi.h>
#include <sys/segments.h>
#include <signal.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>
#include <jlib.h>
#include "../comm/comm_key.c"

int lock_memory(void *ptr, int size, int code);
static _go32_dpmi_seginfo __jlib_kb_old;   /* original prot-mode key IRQ */
static _go32_dpmi_seginfo __jlib_kb_new;   /* prot-mode interrupt segment info */
                   
/*+------------------------------------------------------------------------+ */
/*| Initialise the keyboard.                                               | */
/*+------------------------------------------------------------------------+ */
void kb_init(void)
{
 if(__jlib_kb_initted){
    return;
 }

 if(_bios_keybrd(_KEYBRD_SHIFTSTATUS)&64){    /* determine shift status */
    __jlib_caps_state=1;
 }

 lock_memory((void *)&__jlib_kb_state,  128, 0);
 lock_memory((void *)&__jlib_ascii_tab, 128, 0);
 lock_memory((void *)&__jlib_shift_tab, 128, 0);
 lock_memory((void *)&__jlib_caps_tab,  128, 0);
 lock_memory((void *)&__jlib_kb_buff,   256, 0);
 lock_memory((void *)&__jlib_kb_start,  sizeof(__jlib_kb_start), 0);
 lock_memory((void *)&__jlib_last_ext,  sizeof(__jlib_last_ext), 0);
 lock_memory((void *)&__jlib_kb_end,    sizeof(__jlib_kb_end), 0);
 lock_memory((void *)&__jlib_kb_initted, sizeof(__jlib_kb_initted), 0);
 lock_memory((void *)&__jlib_caps_state,   sizeof(__jlib_caps_state), 0);
 lock_memory(__jlib_keyint, (int)__jlib_kb_int_end-(int)__jlib_keyint, 1);

 fflush(stdin);

 __jlib_kb_new.pm_offset = (int)__jlib_keyint;       /* pm handler */
 _go32_dpmi_allocate_iret_wrapper(&__jlib_kb_new);
 __jlib_kb_new.pm_selector = _go32_my_cs();
 _go32_dpmi_get_protected_mode_interrupt_vector(9, &__jlib_kb_old);
 _go32_dpmi_set_protected_mode_interrupt_vector(9, &__jlib_kb_new);

 __jlib_kb_initted=1;
 kb_clear();
}


/*+------------------------------------------------------------------------+ */
/*| Shut down the keyboard.                                                | */
/*+------------------------------------------------------------------------+ */
void kb_closedown(void)
{
   if (!__jlib_kb_initted){
      return;
   }
   _go32_dpmi_set_protected_mode_interrupt_vector(9, &__jlib_kb_old);
   _go32_dpmi_free_iret_wrapper(&__jlib_kb_new);

   __jlib_kb_initted = 0;
}


int lock_memory(void *ptr, int size, int code)
{
   __dpmi_meminfo meminfo;
   int seg = (code ? _my_cs() : _my_ds());

   if (__dpmi_get_segment_base_address(seg, &meminfo.address) != 0){
      return -1;
   }

   meminfo.size = size;
   meminfo.address += (long)ptr;
   return __dpmi_lock_linear_region(&meminfo);
}
