/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <dos.h>
#include <stdlib.h>
#include <grx20.h>
#include <go32.h>
#include <jlib.h>

char version_string[] = "djgpp V2 (DPMI) grx2.0";

GrContext *__jlib_fake_context;  /* used for blits */
GrContext *__jlib_fake_partial_context;

static int __jlib_previous_mode;  /* holds previous mode */
int        __jlib_mouse_present,__jlib_planesize;
static UBYTE __jlib_mode_initted;
unsigned int _jlib_off;          /* dos memory offset */
unsigned short _jlib_sel;        /* dos memory selector */


/*+------------------------------------------------------------------------+ */ 
/*|Set the video mode.                                                     | */ 
/*+------------------------------------------------------------------------+ */ 
int screen_set_video_mode(void)
{
 int i;

 JLIB_ENTER("screen_set_video_mode");

 if(__jlib_mode_initted){
    JLIB_LEAVE;
    return 0;
 }

 JLIB_SIGNAL_SETUP;

 _jlib_sel = _dos_ds;
 _jlib_off = 0;
 
 __jlib_previous_mode=GrCurrentMode(); /* save current mode */

 if(GrSetMode(GR_width_height_color_graphics,SCREEN_WIDTH,SCREEN_HEIGHT,SCREEN_NUM_COLORS)==0){
    JLIB_LEAVE;
    return 0;
 }

  __jlib_planesize= GrFramePlaneSize(GrCoreFrameMode(),SCREEN_WIDTH,SCREEN_HEIGHT);

  if(__jlib_planesize <= 0L){
     JLIB_LEAVE;
     return(0);
  }
  
  /* should possibly check upper bound of plane size here */

  __jlib_fake_context=GrCreateFrameContext(GR_frameRAM8,SCREEN_WIDTH,SCREEN_HEIGHT,(char **)0,NULL);
	
  if(__jlib_fake_context == NULL){
    JLIB_PRINT_DEBUG_INFO("Couldn't initialise context.\n");
    JLIB_LEAVE;
    return 0;
  }

  __jlib_fake_partial_context = calloc(1,sizeof(GrContext));

  if(__jlib_fake_partial_context == NULL){
    JLIB_PRINT_DEBUG_INFO("Couldn't initialise context.\n");
    JLIB_LEAVE;
    return 0;
  }

  /* free the memory grx allocated */
  for(i=0;i<4;i++){
     if(__jlib_fake_context->gc_baseaddr[0] != NULL){
       free(__jlib_fake_context->gc_baseaddr[0]);
     }
  }

  __jlib_mouse_present = GrMouseDetect();

  if(__jlib_mouse_present){
    GrMouseEventMode(0);  /* use polled mode */
    GrMouseInit();
    GrMouseEventEnable(0,1); /* don't enable keyboard events */
    GrMouseEraseCursor();
  }

  __jlib_mode_initted=1;

  JLIB_LEAVE;
  return 1; /* mode set ok */
}


/*+------------------------------------------------------------------------+ */ 
/*|Restore the video mode.                                                 | */
/*+------------------------------------------------------------------------+ */ 
void screen_restore_video_mode(void)
{
  JLIB_ENTER("screen_restore_video_mode");

  if(!__jlib_mode_initted){
     JLIB_LEAVE;
     return;
  }
  
  __jlib_mode_initted=0;

  GrSetMode(__jlib_previous_mode);
  JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */ 
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */ 
int screen_get_page(void)
{
 JLIB_ENTER("screen_get_page");
 JLIB_LEAVE;
 return 1;
}


/*+------------------------------------------------------------------------+ */ 
/*|Show the current drawing page.                                          | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_show_page(int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Set drawing output to a page.                                           | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_set_page(int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill(UBYTE color) 
{
 JLIB_ENTER("screen_fill");
 GrClearScreen((int)color);
 JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+ */
/*|Clear the screen.                                                       | */
/*+------------------------------------------------------------------------+ */ 
void screen_clear(void) 
{
 JLIB_ENTER("screen_clear");
 GrClearScreen(0);
 JLIB_LEAVE;
}


#define MASK_1 0x00000001
#define MASK_16s 0xfffffff0

/* return the best copy method for two addresses and a length */
JINLINE int get_best_copy_method (void *addr1, void *addr2, unsigned int len)
{
   if (len & MASK_16s){
	/* len is > 16 */
	(unsigned int) addr1 += (unsigned int) addr2;

	if ((unsigned int) addr1 & MASK_1){
	     /* one address is odd, one is even */
	     return ALIGNMENT_STATE_1;
	}
	else{
	     /* both address are either odd or even */
	     if ((unsigned int) addr2 & MASK_1){
		  /* both are odd */
		  if (len & MASK_1){
		       return ALIGNMENT_STATE_2;	/* length is odd */
		  }
		  else{
		       return ALIGNMENT_STATE_5;	/* length is even */
		  }
	     }
	     else{
		  /* both are even */
		  if (len & MASK_1){
		       return ALIGNMENT_STATE_4;	/* length is odd */
		  }
		  else{
		       return ALIGNMENT_STATE_3;	/* length is even */
		  }
	     }
	}
   }
   else{
	/* len is <= 16, use sb */
	return ALIGNMENT_STATE_1;
   }
}
