/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <jlib.h>

/* fake these functions for generic targets */
#ifdef GENERIC
void popup_about(UBYTE back_col,UBYTE front_col){
 return;
}
void popup_info(char *message,UBYTE back_col,UBYTE front_col){
 return;
}
#else

int __jlib_register_event(int *x,int*y);

/* event types returned by __jlib_register_event */
#define EV_MOUSE 1
#define EV_KB    2

#define LINE(x) ((x)*CHAR_HEIGHT('a'))
#define COL(x) ((x)*CHAR_WIDTH('a'))

#define HALF_W (CHAR_WIDTH('a')/2)
#define HALF_H (CHAR_HEIGHT('a')/2)

/*+------------------------------------------------------------------------+*/
/*| pop up a screen detailing the jlib target,  version etc                |*/
/*+------------------------------------------------------------------------+*/
void popup_about(UBYTE back_col,UBYTE front_col)
{
 char text[40];
 buffer_rec *pbuff;
 int xpos,ypos;
 
 JLIB_ENTER("popup_about");
 
 pbuff = buff_init(COL(40),LINE(12)); /* doesn't return if failed */
 
 /* fill buff with background and outline box */
 buff_fill(pbuff,back_col);
 buff_draw_box(pbuff,0,0,B_MAX_X(pbuff),B_MAX_Y(pbuff),front_col);  

 /* put header info */
 buff_draw_string(pbuff,"JLib Function Library",COL(10),LINE(1),front_col);

 /* give myself an ego boost! */
 buff_draw_string(pbuff,"Copyright (c) 1995 Jonathan Griffiths.",COL(1),LINE(3),front_col); 
 
 /* put version number */
 sprintf(text,"Version: %1.2f\n",jlib_return_version_number());
 buff_draw_string(pbuff,text,COL(10),LINE(6),front_col);
 
 /* put target details */
 sprintf(text,"Target:  %s\n",jlib_return_version_string());
 buff_draw_string(pbuff,text,COL(10),LINE(7),front_col);

 /* draw 'ok' box */
 buff_draw_box(pbuff,COL(34)+HALF_W,LINE(8)+HALF_H,COL(40)-HALF_W-1,LINE(12)-HALF_H,front_col);  
 buff_draw_string(pbuff,"OK",COL(36)+HALF_W,LINE(9)+HALF_H,front_col); 
 
 if(MOUSE_AVAILABLE){
    mouse_hide_pointer();
 }  
 
 screen_blit_buff_to(COL(20),LINE(6),pbuff,0,0,B_MAX_X(pbuff),B_MAX_Y(pbuff));
  
 if(MOUSE_AVAILABLE){
    mouse_show_pointer();
 }
 
 /* wait for user to quit appropriately */
 do{
  switch(__jlib_register_event(&xpos,&ypos)){
     case EV_KB:
 
        buff_free(pbuff);
 
        JLIB_LEAVE;
        return;
        
     case EV_MOUSE:
 
        if((xpos > (COL(20) + COL(34)+HALF_W)) &&
           (xpos < (COL(20) + COL(40)-HALF_W)) &&
           (ypos > (LINE(6) + LINE(8)+HALF_H)) &&
           (ypos < (LINE(6) + LINE(12)-HALF_H))){ 
          
           buff_free(pbuff);

           JLIB_LEAVE;
           return;
        }
        
        break;
        
     default:
 
        buff_free(pbuff);
        jlib_exit("Invalid Event.");

        break;
  }
 }while(1);
        
 JLIB_LEAVE
}


#define MESS_WIDTH 40
#define MAX_LINES  14
#define P_OUTX ((SCREEN_WIDTH-COL(MESS_WIDTH))/2)
#define P_OUTY ((SCREEN_HEIGHT-LINE(num_lines))/2)


/*+------------------------------------------------------------------------+*/
/*| pop up a message with an OK button.                                    |*/
/*+------------------------------------------------------------------------+*/
void popup_info(char *message,UBYTE back_col,UBYTE front_col)
{
 buffer_rec *pbuff;
 int i,x,y,num_lines,xpos,ypos,count;


 JLIB_ENTER("popup_info");

 if(message==NULL){
    jlib_exit(jlib_msg(JLIB_ENULL));
 }
 
 
 count = i = 0;

 while(message[i] != '\0'){
    if(message[i] == '\n'){
        count++;
    }
    i++;
 }

 num_lines = i/MESS_WIDTH;
 
 if(count > num_lines){
    num_lines = count;
 }

 if(num_lines > MAX_LINES){
    num_lines = MAX_LINES;
 }
 else{
    if(num_lines == 0){
       num_lines = 1;
    }
 }
       
 num_lines += 6;  /* for ok box */
 
 /* create a buffer the right size */
 pbuff = buff_init(COL(MESS_WIDTH),LINE(num_lines));
 
 /* fill buff with background and outline box */
 buff_fill(pbuff,back_col);
 buff_draw_box(pbuff,0,0,B_MAX_X(pbuff),B_MAX_Y(pbuff),front_col);  

 /* draw lines */
 x = y = 1;

 /* note: this relies on i still being the length of the string message */
 if(i>(MESS_WIDTH-2)*(num_lines-4)){
    i=(num_lines-4)*(MESS_WIDTH-2);
 }

 /* draw message */ 
 while(i-- > 0 ){
     if(*message == '\n'){
        /* move to the next line */
        x=1;
        y++;
     }
     else{
        buff_draw_char(pbuff,*message,COL(x),LINE(y),front_col);

        if(++x > (MESS_WIDTH-2)){
           /* move to the next line */
           x=1;
           y++;
        }
     }
     
     message++;          
 }

 /* draw 'ok' box */
 buff_draw_box(pbuff,COL(MESS_WIDTH-6)+HALF_W,LINE(num_lines-4)+HALF_H,
                     COL(MESS_WIDTH)-HALF_W-1,LINE(num_lines)-HALF_H,front_col);  
 buff_draw_string(pbuff,"OK",COL(MESS_WIDTH-5)+HALF_W,LINE(num_lines-3)+HALF_H,front_col); 


 if(MOUSE_AVAILABLE){
    mouse_hide_pointer();
 }

 /* blit it */
 screen_blit_buff_to(P_OUTX,P_OUTY,pbuff,0,0,B_MAX_X(pbuff),B_MAX_Y(pbuff));

 if(MOUSE_AVAILABLE){ 
    mouse_show_pointer();
 }

 do{
  switch(__jlib_register_event(&xpos,&ypos)){

     case EV_KB:
        buff_free(pbuff);

        JLIB_LEAVE;
        return;
        
     case EV_MOUSE:
        if((xpos > (P_OUTX + COL(MESS_WIDTH-6)+HALF_W)) &&
           (xpos < (P_OUTX + COL(MESS_WIDTH)-HALF_W)) &&
           (ypos > (P_OUTY + LINE(num_lines-4)+HALF_H)) &&
           (ypos < (P_OUTY + LINE(num_lines)-HALF_H))){
        
           buff_free(pbuff);

           JLIB_LEAVE;
           return;
        }
        break;
        
     default:
        buff_free(pbuff);

        jlib_exit("Invalid Event.");
  }
 }while(1);

 JLIB_LEAVE
}


/*+------------------------------------------------------------------------+*/
/*| wait for an event,  return its type and position if appropriate.       |*/
/*+------------------------------------------------------------------------+*/
int __jlib_register_event(int *x,int*y)
{
 int button = 0;

 /* handle the no keyboard or mouse support case */
#if (KEYBOARD_AVAILABLE == 0) && (MOUSE_AVAILABLE == 0)
 fflush(stdin);
 
 fgetc(stdin);
 
 return EV_KB;

#endif

/* clear the keyboard if it is available */
#if (KEYBOARD_AVAILABLE == 1)
    kb_clear();
#endif

 /* handle the no mouse but keyboard support case */
#if ((MOUSE_AVAILABLE == 0) && (KEYBOARD_AVAILABLE == 1))

 /* this loop waits until a key is pressed */
 do{
   /* wait */      
 }while(!kb_key_hit());

 kb_clear();
   
 return EV_KB;

#endif


/* handle mouse but no keyboard support */
#if ((MOUSE_AVAILABLE == 1) && (KEYBOARD_AVAILABLE == 0)) 

 /* this loop waits until a mouse button is pressed */
 do{
   mouse_get_status(x,y,&button);
         
 }while(!(BUTTON_DOWN(button)));

 /* wait for mouse buton to release */
 do{
   mouse_get_status(x,y,&button);
      
 }while((BUTTON_DOWN(button)));
 
 return EV_MOUSE;

#endif



/* handle both mouse and keyboard support */
#if ((MOUSE_AVAILABLE == 1) && (KEYBOARD_AVAILABLE == 1)) 

 /* this loop waits until a mouse button or key is pressed */
 do{
   mouse_get_status(x,y,&button);
      
 }while( !BUTTON_DOWN(button) && !kb_key_hit() );

 /* return if keyboard event */
 if (!BUTTON_DOWN(button)){

   kb_clear();

   return EV_KB;
 }

 /* else wait for mouse button to release */
 do{
   mouse_get_status(x,y,&button);
      
 }while((BUTTON_DOWN(button)));
 
 return EV_MOUSE;

#endif

 /* safety call - pretend a key was hit if we somehow get here ... */
 return EV_KB;
 
}
 
#endif /* ndef GENERIC */
