/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <stdio.h>

#define COL(x)   ((x)*CHAR_WIDTH('a'))
#define LINE(x)  ((x)*CHAR_HEIGHT('a'))
#define TEXT_COL 15

/* this demo just draws some text on the screen. */

int main(void)
{
 UBYTE c;
 buffer_rec *offscreen;

 JLIB_DEBUG_OFF
 screen_set_video_mode();
 
 offscreen=buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 screen_put_pal(TEXT_COL,255,255,255);

 for(c=32;c<32+80;c++){
     buff_draw_char(offscreen,c,COL(c-32),LINE(2),TEXT_COL);
 }

 for(c=32+80;c<128;c++){
     buff_draw_charNC(offscreen,c,COL(c-80-32),LINE(3),TEXT_COL);
 }

 buff_draw_string(offscreen,"Welcome to a new and wonderful font.",COL(5),LINE(5),TEXT_COL);
 buff_draw_string(offscreen,"I hope you enjoy looking at it,",COL(5),LINE(6),TEXT_COL);
 buff_draw_string(offscreen,"Because it's the only one there is!",COL(5),LINE(7),TEXT_COL);
 buff_draw_string(offscreen,"main()",COL(5),LINE(8),TEXT_COL);
 buff_draw_stringNC(offscreen,"  int i,j,screen_pos;",COL(5),LINE(9),TEXT_COL);
 buff_draw_stringNC(offscreen,"  screen_draw_stringNC(); ",COL(5),LINE(10),TEXT_COL);

 screen_blit_fs_buffer(offscreen);
 fgetc(stdin);
   
 screen_restore_video_mode();
 return(1);
}



