INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_memcmp:FN_CALL PTR
p_fn_fc_memcmp LABEL FN_CALL PTR
	P_FN_CALL @memcmp
	P_FN_CALL @memcmp_sss
	P_FN_CALL @memcmp_dss
_DATA ENDS

 ENDIF
ENDIF

;memcmp() -- Compare memory blocks
;int fn_call memcmp(const void __near * const, const void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ds
;   p_m2	near pointer, (source) offset from ds
;   cnt 	number of characters to compare
;RETURNS: (int)
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2

CLIBC_16_CS SEGMENT
memcmp	    PROC FN_CALL C uses es si di,
		p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, cnt:WORD

	    mov ax, ds
	    mov es, ax

	    mov di, [p_m1]	    ;es:di = p_m1, dest
	    mov si, [p_m2]	    ;ds:si = p_m2, src

	    xor ax, ax
	    cmp si,di		    ;Equal?
	    je @@done
@@cont:
	    mov cx, [cnt]	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
memcmp ENDP

; __fastcall
;   bx	    p_m1, (dest) offset from ds
;   ax	    p_m2, (source) offset from ds
;   dx	    cnt
;int __fastcall fn_call memcmp(const void __near * const, const void __near * const, const int);
@memcmp PROC FN_CALL USES es si di cx

	    mov di, bx	    ;es:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov ax, ds
	    mov es, ax

	    xor ax, ax
	    cmp si,di		    ;Equal?
	    je @@done
@@cont:
	    mov cx, dx	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
@memcmp ENDP

;memcmp_sss() -- Compare memory blocks
;int fn_call memcmp_sss(const void __near * const, const void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ds
;   p_m2	near pointer, (source) offset from ss
;   cnt 	number of characters to compare
;RETURNS: (int)
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2
memcmp_sss PROC FN_CALL C uses ds es si di,
		p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, cnt:WORD

	    mov cx, ds
	    mov es, cx
	    mov bx, ss
	    mov ds, bx

	    mov di, [p_m1]	    ;es:di = p_m1, dest
	    mov si, [p_m2]	    ;ds:si = p_m2, src

	    xor ax, ax
	    cmp cx, bx
	    jne @@cont
	    cmp si,di		    ;Equal?
	    jne @@cont
	    jmp @@done		    ; Yes
@@cont:
	    mov cx, [cnt]	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
memcmp_sss ENDP

; __fastcall
;   bx	    p_m1, (dest) offset from ds
;   ax	    p_m2, (source) offset from ss
;   dx	    cnt
;int __fastcall fn_call memcmp_sss(const void __near * const, const void __near * const, const int);
@memcmp_sss PROC FN_CALL USES ds es si di bx cx

	    mov di, bx	    ;es:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov bx, ds
	    mov es, bx
	    mov cx, ss
	    mov ds, cx

	    xor ax, ax
	    cmp bx, cx
	    jne @@cont
	    cmp si,di		    ;Equal?
	    je @@cont
	    jmp @@done		    ; Equal
@@cont:
	    mov cx, dx	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
@memcmp_sss ENDP

;memcmp_dss() -- Compare memory blocks
;int fn_call memcmp_dss(const void __near * const, const void __near * const, const int);
;GIVEN:
;   p_m1	near pointer, (dest) offset from ss
;   p_m2	near pointer, (source) offset from ds
;   cnt 	number of characters to compare
;RETURNS: (int)
;   <0		m1 < m2
;   0		m1 = m2
;   >0		m1 > m2
memcmp_dss PROC FN_CALL C uses es si di,
		p_m1:NEAR16 PTR, p_m2:NEAR16 PTR, cnt:WORD

	    mov cx, ss
	    mov es, cx
	    mov bx, ds

	    mov di, [p_m1]	    ;es:di = p_m1, dest
	    mov si, [p_m2]	    ;ds:si = p_m2, src

	    xor ax, ax
	    cmp cx, bx
	    jne @@cont
	    cmp si,di		    ;Equal?
	    jne @@cont
	    jmp @@done		    ; Yes
@@cont:
	    mov cx, [cnt]	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
memcmp_dss ENDP

; __fastcall
;   bx	    p_m1, (dest) offset from ss
;   ax	    p_m2, (source) offset from ds
;   dx	    cnt
;int __fastcall fn_call memcmp_dss(const void __near * const, const void __near * const, const int);
@memcmp_dss PROC FN_CALL USES es si di bx cx

	    mov di, bx	    ;es:di = p_m1
	    mov si, ax	    ;ds:si = p_m2
			    ;dx = cnt
	    mov bx, ss
	    mov es, bx
	    mov cx, ds

	    xor ax, ax
	    cmp bx, cx
	    jne @@cont
	    cmp si,di		    ;Equal?
	    je @@cont
	    jmp @@done		    ; Equal
@@cont:
	    mov cx, dx	   ;CX = count
	    jcxz @@done
	    repe cmps BYTE PTR ds:[si], es:[di]	    ;Compare memory
	    ; if ZF, then success
	    je @@done
	    ja @@above
	    ; below (p_m2<p_m1, or p_m1<p_m2)
	    inc ax
	    jmp @@done
@@above:
	    ; above (p_m2>p_m1, or p_m1<p_m2)
	    dec ax
@@done:
	    ret
@memcmp_dss ENDP

CLIBC_16_CS ENDS
END
