INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_isspace:FN_CALL PTR
p_fn_fc_isspace P_FN_CALL @isspace
_DATA ENDS

 ENDIF
ENDIF


; isspace
; int fn_call isspace(const int);
; RETURNS:
;   0	if fails test condition
;   !0	if satisfies test condition
; NOTES:
;  White space character (0x09-0x0d, 0x20)
CLIBC_16_CS SEGMENT
isspace PROC FN_CALL C, nchar:WORD
    xor ax, ax
    mov bx, nchar
    cmp bl, 20h
    je @@yes
    cmp bl, 09h
    jl @@exit
    cmp bl, 0Dh
    ja @@exit
@@yes:
    inc ax
@@exit:
    ret
isspace ENDP

; __fastcall
;   AX	    nchar
; int __fastcall fn_call isspace(const int);
@isspace PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax
    cmp bl, 20h
    je @@yes
    cmp bl, 09h
    jl @@exit
    cmp bl, 0Dh
    ja @@exit
@@yes:
    inc ax
@@exit:
    ret
@isspace ENDP

CLIBC_16_CS ENDS
END
