INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_islower:FN_CALL PTR
p_fn_fc_islower P_FN_CALL @islower
_DATA ENDS

 ENDIF
ENDIF

;islower() - Lowercase letter('a'-'z')
;int fn_call islower(const int);

;RETURNS:
;   0	    is NOT a lowercase letter
;   1	    is	   a lowercase letter

CLIBC_16_CS SEGMENT
islower PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, 'a' ; lowercase?
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
islower ENDP

; __fastcall
;   AX	    num
;int __fastcall fn_call islower(const int);
@islower PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, 'a' ; lowercase?
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@islower ENDP
CLIBC_16_CS ENDS
END
