/* memmove.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"memmove.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(memmove)
#endif

// memmove() -- Move memory block
//  void * memmove(void * const, const void * const);
// GIVEN:
//	p_m1	pointer to destination block 1.
//	p_m2	pointer to source block 1.
//	cnt	number of bytes to move.
// RETURNS: (r8)
//	pointer	to destination block (p_m1)
// NOTES:
//  no restrictions concerning block overlap.
//  returns immediatly if p_m1==p_m2
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(memmove)
ilibc_64_proc_prologue
ilibc_64_proc_body
p_m1==r32
p_m2==r33
cnt==r34
tmp==r11
ret_ptr==r8
	mov ret_ptr=p_m1
	cmp.eq p30,p31=p_m1,p_m2	// if(p_m1==p_m2)
	(p30) br.cond.spnt Exit		//   goto Exit
	cmp.eq p30,p31=cnt,r0		// if(cnt==0)
	(p30) br.cond.spnt Exit		//   goto Exit
	cmp.ltu p30,p31=p_m1,p_m2	// if(p_m1<p_m2)
	(p30) br.cond.sptk Normal	//   goto Normal
	// Backwards
	add p_m1=p_m1,cnt		// p_m1+=cnt
	add p_m2=p_m2,cnt		// p_m2+=cnt;
LoopB:
	cmp.eq p30,p31=cnt,r0		// if (cnt==0)
	(p30) br.cond.spnt Exit		//   goto Exit
	sub cnt=cnt,r0,1		// --cnt;
	ld1 tmp=[p_m2],-1		// tmp=*(p_m2--);
	st1 [p_m1]=tmp,-1		// *(p_m1--)=tmp;
	br.cond.sptk LoopB
// ----------------------------	
Normal:
	// Forwards
LoopN:
	cmp.eq p30,p31=cnt,r0		// if (cnt==0)
	(p30) br.cond.spnt Exit		//   goto Exit
	sub cnt=cnt,r0,1		// --cnt;
	ld1 tmp=[p_m2],1		// tmp=*(p_m2++);
	st1 [p_m1]=tmp,1		// *(p_m1++)=tmp;
	br.cond.sptk LoopN		// goto LoopN
// -----------------------------
Exit:
ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(memmove)
