/* iscsymf.S, ilibc_64.a */
/* Byron Young, 2002 */

#include "ilibc_64/ilibc_64.inc"

	.file	"iscsymf.S"
	.pred.safe_across_calls p1-p5,p16-p63
	
#if ILIBC_64_EXTERN_PTRS==ILIBC_64_EXTERN_PTRS_YES
ilibc_64_extern_ptrs_define(iscsymf)
#endif

// iscsymf
// GIVEN:
//	chr	character to use in comparison.
// RETURNS: (r8)
//	0	if condition false.
//	!0	if condition is true.
// NOTES:
//  only the last byte of chr is used for comparisons.
ILIBC_64_PROCEDURE_SECTION_NAME
ilibc_64_proc_start(iscsymf)
ilibc_64_proc_prologue
ilibc_64_proc_body
ret_val==r8
chr==r32
tmp==r11
	mov tmp=0xFF
	and chr=tmp,chr		// chr&0xFF
	mov ret_val=r0		// ret_val=0;
	cmp.eq p30,p31='_',chr	// if ('_'==chr)
	(p30) br.cond.spnt Yes	//  goto Yes
	cmp.gtu p30,p31='A',chr	// if ('A'>chr)
	(p30) br.cond.spnt Exit	//  goto Exit
	cmp.geu p30,p31='Z',chr	// if ('Z'>=chr)
	(p30) br.cond.spnt Yes	//  goto Yes
	cmp.gtu p30,p31='a',chr	// if ('a'>chr)
	(p30) br.cond.spnt Exit	//  goto Exit
	cmp.ltu p30,p31='z',chr	// if ('z'<chr)
	(p30) br.cond.spnt Exit //  goto Exit
Yes:
	add ret_val=ret_val,r0,1	// ++ret_val
Exit:

ilibc_64_proc_epilogue
	br.ret.sptk.many b0
ilibc_64_proc_end(iscsymf)
