
.686P

; clibc_16.inc, clibc_16.lib
; Byron Young, 2002
; Global include file for clibc_16.lib functions
; DO NOT INCLUDE DIRECTLY!

; EXPECTED DEFINED MACROS
; NOTE:
;   if none of the following are defined, defaults to:
;	DEBUG_YES, CLIBC_16_FN_CALL_NEARCALL, CLIBC_16_EXTERN_PTRS_NO
;	CLIBC_16_FUNCTION_SEG_NAME _TEXT, CLIBC_16_EXTERN_PTRS_SEG_NAME _DATA.
;	CLIBC_16_MODULE NONE.
;
; DEBUG - Determines if some debug info is generated.
;		     DEBUG_NO=0
;		     DEBUG_YES=1 (Default)
; CLIBC_16_FN_CALL - Near or far function calls.
;		     CLIBC_16_FN_CALL_NEARCALL=0 (Default)
;		     CLIBC_16_FN_CALL_FARCALL=1
; CLIBC_16_EXTERN_PTRS - If generate pointers to functions
;		     CLIBC_16_EXTERN_PTRS_NO=0 (Default)
;		     CLIBC_16_EXTERN_PTRS_YES=1
; CLIBC_16_FN_CALL_FARCALL_SEG - Combine method for far call functions.
;		     Undefined: (Default for NEARCALL)
;		     CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE=0 (Default for FARCALL)
;		     CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE=1
; CLIBC_16_FUNCTION_SEG_NAME - (base) name of function code segment.
;		     Defaults to either _TEXT or _CLIBC_16.
; CLIBC_16_EXTERN_PTRS_SEG_NAME - Data seg name for pointers.
;		     Defaults to Undefined, _DATA.
;
; CLIBC_16_MODULE - name of module/group that is including this include file.
;		     Defaults to NONE, and an error.
;		     Set to function group/ module. At exit, set to NONE.
;		     Internal use only.
;
;INTERESTING VALUES
; CLIBC_16_FUNCTION_SEG_DEFINITION - the full segment definition for
;		     the functions.
; CLIBC_16_EXTERN_PTRS_SEG_DEFINITION - the full segment definition for
;		     the external pointers.

; Some values, and macros
IFNDEF DEBUG_NO
 DEBUG_NO EQU 0
ENDIF

IFNDEF DEBUG_YES
 DEBUG_YES EQU 1
ENDIF

IFNDEF CLIBC_16_FN_CALL_NEARCALL
 CLIBC_16_FN_CALL_NEARCALL EQU 0
ENDIF

IFNDEF CLIBC_16_FN_CALL_FARCALL
 CLIBC_16_FN_CALL_FARCALL EQU 1
ENDIF

IFNDEF CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
 CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE EQU 0
ENDIF

IFNDEF CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
 CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE EQU 1
ENDIF

IFNDEF CLIBC_16_EXTERN_PTRS_NO
 CLIBC_16_EXTERN_PTRS_NO EQU 0
ENDIF

IFNDEF CLIBC_16_EXTERN_PTRS_YES
 CLIBC_16_EXTERN_PTRS_YES EQU 1
ENDIF

CLIBC_16_FUNCTION_SEG_DEFINITION EQU WORD PUBLIC USE16 'CODE'

CLIBC_16_EXTERN_PTRS_SEG_DEFINITION EQU WORD PUBLIC USE16 'DATA'

; Usage MAKE_MULT_NAME <%CLIBC_16_MODULE>,<%CLIBC_16_FUNCTION_SEG_NAME>
; Defines the MULTIPLE segment name
; Creates the MULTIPLE segment definition
; Ex.
; CLIBC_16_MODULE EQU STRING
; CLIBC_16_FUNCTION_SEG_NAME EQU _CLIBC_16
; MAKE_MULT_NAME <%CLIBC_16_MODULE>,<%CLIBC_16_FUNCTION_SEG_NAME>
; Creates
; CLIBC_16_FUNCTION_SEG_NAME_STRING EQU STRING_CLIBC_16
; CLIBC_16_FUNCTION_SEG_NAME_STRING SEGMENT CLIBC_16_FUNCTION_SEG_DEFINITION
; CLIBC_16_FUNCTION_SEG_NAME_STRING ENDS
; Which results in the STRING_CLIBC_16 segment definition.
IFNDEF MAKE_MULT_NAME
 MAKE_MULT_NAME MACRO pa, pb
  CLIBC_16_FUNCTION_SEG_NAME_&pa EQU &pa&&pb
  CLIBC_16_FUNCTION_SEG_NAME_&pa SEGMENT CLIBC_16_FUNCTION_SEG_DEFINITION
  CLIBC_16_FUNCTION_SEG_NAME_&pa ENDS
 ENDM
ENDIF

; Print out the MULTIPLE segment name
; Usage: PRINT_MULT_NAME <%CLIBC_16_MODULE>
IFNDEF PRINT_MULT_NAME
 PRINT_MULT_NAME MACRO pa
  %ECHO "CLIBC_16_FUNCTION_SEG_NAME_&pa" EQU CLIBC_16_FUNCTION_SEG_NAME_&pa
 ENDM
ENDIF

; Check to see if CLIBC_16_MODULE==NONE
; Usage: IS_CLIBC_16_MODULE_NONE <%CLIBC_16_MODULE>
IS_CLIBC_16_MODULE_NONE MACRO pa
IF <&pa> EQ <NONE>
 .ERR "Not intended for direct inclusion."
ENDIF
ENDM

; Define the beginning of the code segment
; Usage BEGIN_CODE_SEGMENT <STRING>
BEGIN_CODE_SEGMENT MACRO pa
 IF CLIBC_16_FN_CALL EQ CLIBC_16_FN_CALL_NEARCALL
   CLIBC_16_FUNCTION_SEG_NAME SEGMENT
 ELSE
  IF CLIBC_16_FN_CALL_FARCALL_SEG EQ CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
   CLIBC_16_FUNCTION_SEG_NAME_&pa SEGMENT
  ELSE
   CLIBC_16_FUNCTION_SEG_NAME SEGMENT
  ENDIF
 ENDIF
ENDM

; Define the ending of the code segment
; Usage END_CODE_SEGMENT <STRING>
END_CODE_SEGMENT MACRO pa
 IF CLIBC_16_FN_CALL EQ CLIBC_16_FN_CALL_NEARCALL
   CLIBC_16_FUNCTION_SEG_NAME ENDS
 ELSE
  IF CLIBC_16_FN_CALL_FARCALL_SEG EQ CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
   CLIBC_16_FUNCTION_SEG_NAME_&pa ENDS
  ELSE
   CLIBC_16_FUNCTION_SEG_NAME ENDS
  ENDIF
 ENDIF
ENDM

;------  defaults
IFNDEF CLIBC_16_MODULE
 CLIBC_16_MODULE EQU NONE
ENDIF

;If forced error here, then CLIBC_16_MODULE set incorrectly.
;IS_CLIBC_16_MODULE_NONE <%CLIBC_16_MODULE>

IFNDEF DEBUG
 DEBUG EQU DEBUG_YES
ENDIF

IFNDEF CLIBC_16_FN_CALL
 CLIBC_16_FN_CALL EQU CLIBC_16_FN_CALL_NEARCALL
ENDIF

IFNDEF CLIBC_16_EXTERN_PTRS
 CLIBC_16_EXTERN_PTRS EQU CLIBC_16_EXTERN_PTRS_NO
ENDIF

IF CLIBC_16_FN_CALL EQ CLIBC_16_FN_CALL_FARCALL
 IFNDEF CLIBC_16_FUNCTION_SEG_NAME
  CLIBC_16_FUNCTION_SEG_NAME EQU _CLIBC_16
 ENDIF
 IFNDEF CLIBC_16_FN_CALL_FARCALL_SEG
  CLIBC_16_FN_CALL_FARCALL_SEG EQU CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
 ELSEIF CLIBC_16_FN_CALL_FARCALL_SEG NE CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
  CLIBC_16_FN_CALL_FARCALL_SEG EQU CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE
 ENDIF
ELSEIF CLIBC_16_FN_CALL EQ CLIBC_16_FN_CALL_NEARCALL
 IFDEF CLIBC_16_FN_CALL_FARCALL_SEG
  .ERR Undefine CLIBC_16_FN_CALL_FARCALL_SEG.
 ENDIF
 IFNDEF CLIBC_16_FUNCTION_SEG_NAME
  CLIBC_16_FUNCTION_SEG_NAME EQU _TEXT
 ENDIF
ELSE
 .ERR CLIBC_16_FN_CALL Invalid.
ENDIF

IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_NO
 IFDEF CLIBC_16_EXTERN_PTRS_SEG_NAME
  .ERR Undefine CLIBC_16_EXTERN_PTRS_SEG_NAME.
 ENDIF
ELSEIF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES
 IFNDEF CLIBC_16_EXTERN_PTRS_SEG_NAME
  CLIBC_16_EXTERN_PTRS_SEG_NAME EQU _DATA
 ENDIF
ELSE
 .ERR CLIBC_16_EXTERN_PTRS Invalid.
ENDIF

; --- more settings, seg names
IF CLIBC_16_FN_CALL EQ CLIBC_16_FN_CALL_NEARCALL
 IFNDEF FN_CALL
  FN_CALL TEXTEQU <NEAR16>
 ENDIF
 %IFNDEF CLIBC_16_FUNCTION_SEG_NAME  ; The actual segment
  CLIBC_16_FUNCTION_SEG_NAME SEGMENT CLIBC_16_FUNCTION_SEG_DEFINITION
  CLIBC_16_FUNCTION_SEG_NAME ENDS
 ENDIF
ELSE ; FARCALL
 IFNDEF FN_CALL
  FN_CALL TEXTEQU <FAR16>
 ENDIF
 IF CLIBC_16_FN_CALL_FARCALL_SEG EQ CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
  MAKE_MULT_NAME <%CLIBC_16_MODULE>,<%CLIBC_16_FUNCTION_SEG_NAME>
 ELSE ;FAR CALL SINGLE
  %IFNDEF CLIBC_16_FUNCTION_SEG_NAME  ; The actual segment
   CLIBC_16_FUNCTION_SEG_NAME SEGMENT CLIBC_16_FUNCTION_SEG_DEFINITION
   CLIBC_16_FUNCTION_SEG_NAME ENDS
  ENDIF
 ENDIF
ENDIF

IFNDEF P_FN_CALL
 P_FN_CALL TYPEDEF FN_CALL PTR
ENDIF

IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES
 %IFNDEF CLIBC_16_EXTERN_PTRS_SEG_NAME	; The actual segment
  CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT CLIBC_16_EXTERN_PTRS_SEG_DEFINITION
  CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS
 ENDIF
ENDIF

; ---- print out debug info
IFDEF DEBUG
 IF DEBUG EQ DEBUG_YES
  %ECHO @FileCur
  %ECHO "DEBUG" EQU DEBUG_YES
  IFNDEF CLIBC_16_FN_CALL_FARCALL_SEG
   ECHO CLIBC_16_FN_CALL_FARCALL_SEG Not Defined.
  ENDIF
  IFNDEF CLIBC_16_EXTERN_PTRS_SEG_NAME
   ECHO CLIBC_16_EXTERN_PTRS_SEG_NAME Not Defined.
  ENDIF
  %ECHO "CLIBC_16_FN_CALL" EQU FN_CALL
  IF CLIBC_16_FN_CALL EQ CLIBC_16_FN_CALL_FARCALL
   %ECHO "CLIBC_16_FN_CALL_FARCALL_SEG" EQU CLIBC_16_FN_CALL_FARCALL_SEG
   IF CLIBC_16_FN_CALL_FARCALL_SEG EQ CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE
    PRINT_MULT_NAME <%CLIBC_16_MODULE>
   ELSE
    %ECHO "CLIBC_16_FUNCTION_SEG_NAME" EQU CLIBC_16_FUNCTION_SEG_NAME
   ENDIF
  ELSE
   %ECHO "CLIBC_16_FUNCTION_SEG_NAME" EQU CLIBC_16_FUNCTION_SEG_NAME
  ENDIF
  %ECHO "CLIBC_16_EXTERN_PTRS" EQU CLIBC_16_EXTERN_PTRS
  IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES
   %ECHO "CLIBC_16_EXTERN_PTRS_SEG_NAME" EQU CLIBC_16_EXTERN_PTRS_SEG_NAME
  ENDIF
  %ECHO "CLIBC_16_MODULE" EQU CLIBC_16_MODULE
 ELSEIF DEBUG EQ DEBUG_NO
;  %ECHO "DEBUG" EQU DEBUG_NO
 ELSE
  ECHO "DEBUG" EQU UNKNOWN
 ENDIF	 ; DEBUG EQ DEBUG_YES
ENDIF ; DEBUG

CLIBC_16_MODULE EQU NONE

;MACROS DEFINED FOR USE UPON EXIT
; CLIBC_16_FUNCTION_SEG_NAME_<MODULE>
;    If segment combine type is multiple, and function call distance far, then
;	 contains the segment name for the group of procs.
;    Otherwise, undefined
; FN_CALL
;    Call distance for all functions in library.
; P_FN_CALL
;    Pointer to call distance.
; CLIBC_16_MODULE
;    Set to NONE.
;SEGMENTS DEFINED ON EXIT
; CLIBC_16_FUNCTION_SEG_NAME
;    The segment containing all the functions.
;    Only defined if CLIBC_16_FUNCTION_SEG_NAME_<MODULE> is not defined.
; CLIBC_16_FUNCTION_SEG_NAME_<MODULE>
;    The segment containing the group of functions.
;    Defined iff segment combine type is multiple, and far.
