/* Copyright (C) 1999 Tobias Romann, see flat.asm for details */
/* 32-bit file access for the flat real mode for C/C++ library
   These functions provide a nice high level interface between your flat
   real mode program and the 16-bit OS.
 */

#include <stdio.h>

#ifndef __FLAT_H
#include "../../flat.h"
#endif

/* The transfer buffer variables.
   It is important that in small data models (i.e. small and medium) the
   buffer resides within the program's data segment!
 */
void far *fbuf_ptr;
unsigned fbuf_size = 0x8000;

/* fread32 -- read a block (of (nearly) any size) into flat memory */
long
fread32 (flatptr p, long n, FILE * stream)
{
  long bytes_left = n, bytes_read = 0, retval;
  flatptr src = PTR2FPTR (fbuf_ptr);

  /* as long as there are bytes to be read */
  while (bytes_left)
    {
      /* if the remaining bytes are more than the size of the transfer
         buffer, read a portion
       */
      if (bytes_left > fbuf_size)
        retval = fread ((void *) fbuf_ptr, 1, fbuf_size, stream);
      else
        retval = fread ((void *) fbuf_ptr, 1, bytes_left, stream);

      if (-1 == retval)
        return (-1);
      else
        bytes_read += retval;

      if (!retval)
        return bytes_read;

      memcpy32 (p, src, retval);
      p += retval;
      bytes_left -= retval;
    }
  return (bytes_read);
}

/* fwrite32 -- write a block (of any size) within flat memory into a
   stream
 */
long
fwrite32 (flatptr p, long n, FILE * stream)
{
  long bytes_left = n, bytes_written = 0, retval;
  flatptr dest = PTR2FPTR (fbuf_ptr);

  while (bytes_left)
    {
      memcpy32 (dest, p, (bytes_left > fbuf_size) ? fbuf_size : bytes_left
        );

      if (bytes_left > fbuf_size)
        retval = fwrite ((void *) fbuf_ptr, 1, fbuf_size, stream);
      else
        retval = fwrite ((void *) fbuf_ptr, 1, bytes_left, stream);

      if (-1 == retval)
        return (-1);
      else
        bytes_written += retval;

      if (!retval)
        return (bytes_written);

      p += retval;
      bytes_left -= retval;
    }
  return (bytes_written);
}
