/* Header structure */
typedef struct{
	unsigned char signature;	/* 03 = dbf, 83 dbf+dbt */
	unsigned char ymd[3];		/* y+1900 m d */
	long last_rec;
	int data_off;				/* This does not seem to be reliable */
	int rec_size;				/* This is okay */
	unsigned char pad[20];
} DBF_HEADER;

typedef struct{
	char name[11];
	char type;
	char xtra[4];
	char left;
	char right;
	char waste[14];
	int offset;
}DBF_STRUCT;

typedef struct
{
	DBF_HEADER head;
	DBF_STRUCT fields[255];
	char *record;
	char *memo;
	int handle;
	char fname[255];
	long recnum;
	int bof;
	int eof;
}DBF;

typedef struct
{
	unsigned sign;
	unsigned version;
	long root;
	long next_page;
	unsigned item_size;
	unsigned key_size;
	unsigned key_dec;
	unsigned max_item;
	unsigned half_page;
	char key_expr[256];
	unsigned char unique;
}NTX_HEADER;



typedef struct{
	long numrecs;
	char pad[508];
}MEMOHEAD;


/* Memo fields are recorded in <fname>.DBT. The starting position of the record */
/* connected with a dbf record is recorded by a 10 byte numeric string in the */
/* DBF file. This number multiplied by 512 gives the starting position of */
/* the memo field within the .DBT file. Each .DBT record is terminated by an */
/* EOF marker, 0x1A. Each .DBT record is a minimum of 512 bytes long. */

/* Field extraction buffer */
extern char db_xcg[256];


DBF *db_open(char *fname, DBF *dbstruc);
int db_pack(DBF *dbstruc);
unsigned db_fcount(DBF *dbstruc);
char *db_field(DBF *dbstruc,unsigned which);
char *db_getd(DBF *, int);
long db_goto(DBF *dbstruc,long which);
long db_header(DBF *dbstruc);
int db_deleted(DBF *dbstruc);
long db_recsize(DBF *dbstruc);
char *indexkey(char *fname,char *key);
long db_lastrec(DBF *dbstruc);
int db_locate(DBF *dbstruc,int , char *);
char *db_lupdate(DBF *dbstruc, char *buff);
long db_skip(DBF *dbstruc,long many);
double db_sum(DBF *, unsigned);
void db_strncpy(char huge *, char huge *, unsigned);
int db_append_blank(DBF *dbstruc);
long db_recno(DBF *dbstruc);
int db_bof(DBF *dbstruc);
int db_eof(DBF *dbstruc);
void db_replace(DBF *dbstruc, int fnum, char *text);
int db_ftchg(DBF *dbstruc, unsigned which, char type);
int db_extmemo(DBF *dbstruc, int which);
int db_recall(DBF *dbstruc);
void db_struct(DBF *dbstruc,DBF_STRUCT *dbdata);
void db_hardcr(char *text);
