/* dtest.c -- Program to test BPLUS database file index module shareware.

	Written by Arnold Cherdak for Turbo C, Version 1.5

	This program exercises the BPLUS module to index, retrieve, and add
	records to the FAMILIES database.  It then produces the Main Street
	Report.

*/
#include <bplus.h>      /* this is part of the BPLUS product */
#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <ctype.h>
#include <string.h>
#include <io.h>

#define TRIM 0  /* TRIM=1 for uniform length keys; =0 for min. length keys */
#define TRIMLENGTH 24
#define FILERR  "\nCAN'T OPEN DATABASE FILE!\n"
#define FILERR2 "\nDATABASE FILE ERROR!\n"
#define ADDKEYERR "\nERROR ADDING KEY TO INDEX!\n"
#define OPENIXERR "\nERROR OPENING INDEX FILE!\n"
#define CLOSEIXERR "\nERROR CLOSING INDEX FILE!\n"
#define READERR "\nERROR READING DATABASE FILE!\n"
#define UPPER 1
#define LOWER 2

struct FAMILY_TYPE     /* database file record structure */
	{
	char name[25];
	char street[25];
	char street_num[10];
	char other_data[68];
	char linefeed;
	char nulbyte;
	};


/**************************************************************************/
               void scrub(char *s, int uplow, char *dest)
/**************************************************************************/
/* This function cleans up a string and returns it in a destination string.
   Leading and trailing blanks are removed, the case is changed to all
   upper, lower, or mixed case depending upon the value of parameter, uplow,
   being 1, 2, or 0, respectively.  Internal blanks are limited to no more
   than one in a sequence.  The source string is not changed.
*/
{
	char *st,c;
	int i,j,flag;

	for(; s[0] == ' '; s++);  /* trim leading blanks */

	/* Copy characters to destination, converting to destination case and
	   limiting runs of blanks to one.
	*/
	i = j = flag = 0;
	while((c = s[i++]) != '\0')
		{
		if(uplow == UPPER)                 /* case becomes UPPER */
			c = toupper(c);
		else if(uplow == LOWER)	           /* case becomes LOWER */
			c = tolower(c);
                                   /* or, case stays as it was */

		if(c == ' ')
			{
			if(flag != 1)         /* flag sez this is first blank */
				{
				flag = 1;
				dest[j++] = c;
				}
			}
		else                        /* character is not a blank */
			{
			flag = 0;
			dest[j++] = c;
			}
		}

#if TRIM
	if(j < TRIMLENGTH)
		for(i=j;i<TRIMLENGTH;i++)   /* make sure all indices are same length */
			dest[i] = ' ';
	dest[TRIMLENGTH] = '\0';		 /* terminate the destination string */
#else
	dest[j] = '\0';                /* terminate the destination string */
	if(dest[--j] == ' ')           /* get rid of trailing blank */
		dest[j] = '\0';
#endif
} /* end scrub */


/**************************************************************************/
                             void main()
/**************************************************************************/
{
union	{
		struct FAMILY_TYPE family;
		char family_buffer[256];
		} db;

ENTRY e;
IX_DESC idx;      /* index file variable */
int i;
FILE *dbfil;
long address;
char str[130];


/* start by opening the database file in text mode */
if((dbfil = fopen("families.dat", "r")) == NULL)
	{
	/* error...can't open database file */
	printf(FILERR);
	exit();
	}


/* Next, create an index file using the street name field as the key.
	The file name is families.idx
	We will allow duplicate keys.

	Now create the index file using 'make_index()'
*/
if(make_index("families.idx", &idx, 1) != IX_OK)
	exit();


/* Read through the database file, obtain the key and record number for each
	record, and install them in the index file using 'add_index()'.
*/
address = 0L;              /* pointer to first record in file */
printf("\n");              /* home the cursor */
while(fgets(&db.family_buffer, 255, dbfil) != (char *) NULL)
	{
	/* clean up messy key & put into structure for add_key. */
	for(i=0;i<25;i++)
		str[i] = db.family.street[i];

   /* terminate the string */
	str[25] = '\0';

   /* trim leading & trailing blanks & reduce to single interior blanks. */
	scrub(str, UPPER, e.key);

	/* display what goes into the index file just for grins... */
	printf("KEY: %-25s ADDRESS: %4ld\n",e.key,address);

   /* current record address in database file */
	e.recptr = address;

   /* add key to index file */
	if(add_key(&e, &idx) != IX_OK)
		/* add_key failed */
		{
		printf(ADDKEYERR);
		exit();
		}

   /* File pointer is already pointing to next record...get the address. */
	address = ftell(dbfil);
	}


/* Now close the index file to flush the file buffer.  I don't really
   know if this is necessary since I don't know how BPLUS maintains the
   file buffer.  However, this will make sure that the whole index file is
   written to disk.
*/
if(close_index(&idx) != IX_OK)
	{
	printf(CLOSEIXERR);
	exit();
	}


/* Re-open the index */
if(open_index("families.idx", &idx, 1) != IX_OK)
	{
	printf(OPENIXERR);
	exit();
	}


/*
   Search for records having Main Street as the street name and print them
   to stdout.  We may have to settle for less than a 100% match on the key
   so just look for the first name, 'MAIN'.

   Since index file isn't sorted, we need to examine each index entry to
   determine if it contains the substring, 'MAIN'.  If it does, print the
   database record and loop back to get the next index record.  Continue
   until the end-of-file for the index.
*/
first_key(&idx);     /* point to first key in index file */
while(next_key(&e, &idx) == IX_OK)
	{
	/* A nice Turbo-C function to find substrings...Gosh! Just like BASIC! */
	if(strstr(e.key, "MAIN") != NULL)
		/* a match is found */
		{
		/* Position the database file pointer to the record */
		if(fseek(dbfil, e.recptr, SEEK_SET) != 0)
			/* file error */
			{
			printf(FILERR2);
			exit();
			}

		/* read a record from the database file and place in family buffer */
		if(fgets(&db.family_buffer, 255, dbfil) == (char *) NULL)
			/* read error */
			{
			printf(READERR);
			exit();
			}

		/* got the record, now print it */
		db.family_buffer[60] = '\0';       /* keeps the printout on screen */
		printf("\n%s",db.family_buffer);
		}

	} /* OK, go back for another... */

} /* end DTEST */
