/* ******* Listing 2 *************************** DYNARRAY.CPP *********
*  dynarray.cpp  Copyright (C) 1990 by Tom Provenzano
* 
*  Allows an array to be dynamically resized at runtime.
**********************************************************************/

#include <string.h>
#include <stdlib.h>
#include <stream.hpp>
#include <errno.h>
#include "dynarray.hpp"

int dynarray::change_size( unsigned newsize ) // change size of storage block
{                                       // can be an increase or decrease
  char *a;
  a = (char *)realloc( array, newsize*elem_size ); // reallocate block
  if ( !a )
    err = errno;                               // signal realloc failure
  else
  {
    array = a;				       // update array address
    elements = newsize;                	       // new element count
  }
  return 0;
}

dynarray::dynarray( unsigned n, unsigned elemsize )
{
  elements = n;
  elem_size = elemsize;
  array = (char *)calloc( elements, elem_size );
  err = ( !array ) ? errno : 0;
}

char *dynarray::pick( int i )
{
  int j = elements;

  if (i >= j)            	// requested index outside current storage
     change_size(i+1);     	// resize
  else if ( i < 0 )		// downsizing required
     return ( change_size(j+=i) ) ? NULL : array+(elements-1)*elem_size;
  return array+i*elem_size;	// pointer to appropriate element
}