/* f.h                    freeware                          xhunga@tiscali.fr */

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_fgab(
double xmin,
double xmax,
double ymin,
double ymax,
double a,
double b,
  char feq[TXT_EQ],
  char geq[TXT_EQ],
double (*P_f)(double x),
double (*P_g)(double x)
)
{
FILE   *fp;
char    FA[FILENAME] = "a";
char    FB[FILENAME] = "b";
double  t;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis lt 8\n");
fprintf(fp," set grid\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp,"%s",geq);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 1",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 1",FB);


fprintf(fp,"\n\n");
fprintf(fp," reset");

             fclose(fp);

        fp = fopen(FA,  "w");

t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a, t);
t = ((*P_g)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a, t);

             fclose(fp);

        fp = fopen(FB,  "w");

t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b, t);
t = ((*P_g)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b, t);

             fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_SolidRevolDiskfg(
double xmin,
double xmax,
double ymin,
double ymax,
double a,
double b,
double r,
double step,
double (*P_f)(double x),
double (*P_g)(double x)
)
{
FILE   *fp;

char    FA[FILENAME] = "a";
char    FB[FILENAME] = "b";
char    FD[FILENAME] = "d";
char    FE[FILENAME] = "e";
char    FR[FILENAME] = "r";
char    FL[FILENAME] = "l";
char    FM[FILENAME] = "m";
char    FO[FILENAME] = "o";
char    FP[FILENAME] = "p";

double  t;
double  i;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis lt 8\n");
fprintf(fp," set grid\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FB);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FD);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FE);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FL);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FM);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FO);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FP);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 9 pt 0",FR);
fprintf(fp,"\n\n");
fprintf(fp," reset");

             fclose(fp);

        fp = fopen(FA,  "w");

t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a,  t);
t = ((*P_g)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a,  t);

             fclose(fp);

        fp = fopen(FB,  "w");

t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b,  t);
t = ((*P_g)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b,  t);

             fclose(fp);

        fp = fopen(FD,  "w");

t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a, -t);
t = ((*P_g)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a, -t);

             fclose(fp);


        fp = fopen(FE,  "w");

t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b,  -t);
t = ((*P_g)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b,  -t);

             fclose(fp);


        fp = fopen(FR,  "w");

t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);
t = (*P_g)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);
t = (*P_g)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.+ (r ),   t);
t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.+ (r ),   t);
t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);

             fclose(fp);

        fp = fopen(FL,  "w");

i = a;
do{
   t = ((*P_f)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, t);
   i += step;
}while(i <=  b);

             fclose(fp);

        fp = fopen(FM,  "w");

i = a;
do{
   t = ((*P_g)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, t);
   i += step;
}while(i <=  b);

             fclose(fp);

        fp = fopen(FO,  "w");

i = a;
do{
   t = ((*P_f)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, -t);
   i += step;
}while(i <=  b);

             fclose(fp);

        fp = fopen(FP,  "w");

i = a;
do{
   t = ((*P_g)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, -t);
   i += step;
}while(i <=  b);

             fclose(fp);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_SolidRevolCylindShellfg(
double xmin,
double xmax,
double ymin,
double ymax,
double a,
double b,
double r,
double step,
double (*P_f)(double x),
double (*P_g)(double x)
)
{
FILE   *fp;
char    FA[FILENAME] = "a";
char    FB[FILENAME] = "b";
char    FD[FILENAME] = "d";
char    FE[FILENAME] = "e";
char    FL[FILENAME] = "l";
char    FM[FILENAME] = "m";
char    FO[FILENAME] = "o";
char    FP[FILENAME] = "p";
char    FR[FILENAME] = "r";

double  t;
double  i;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis lt 8\n");
fprintf(fp," set grid\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FB);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FD);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FE);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FL);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FM);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FO);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FP);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 9 pt 0",FR);
fprintf(fp,"\n\n");
fprintf(fp," reset");

             fclose(fp);

        fp = fopen(FA,  "w");

t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a,  t);
t = ((*P_g)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a,  t);

             fclose(fp);

        fp = fopen(FB,  "w");

t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b,  t);
t = ((*P_g)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b,  t);

             fclose(fp);

        fp = fopen(FD,  "w");

t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", -a,  t);
t = ((*P_g)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", -a,  t);

             fclose(fp);

        fp = fopen(FE,  "w");

t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n",-b,  t);
t = ((*P_g)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n",-b,  t);

             fclose(fp);

        fp = fopen(FR,  "w");

t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);
t = (*P_g)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);
t = (*P_g)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.+ (r ),   t);
t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.+ (r ),   t);
t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);

             fclose(fp);

        fp = fopen(FL,  "w");

i = a;
do{
   t = ((*P_f)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, t);
   i += step;
}while(i <=  b);

             fclose(fp);

        fp = fopen(FM,  "w");

i = a;
do{
   t = ((*P_g)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, t);
   i += step;
}while(i <=  b);

             fclose(fp);

        fp = fopen(FO,  "w");

i = a;
do{
   t = ((*P_f)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", -i, t);
   i += step;
}while(i <=  b);

             fclose(fp);

        fp = fopen(FP,  "w");

i = a;
do{
   t = ((*P_g)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", -i, t);
   i += step;
}while(i <=  b);

             fclose(fp);
}

