/*         .c                       freeware                   xhunga@tiscali.fr
*/
/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"
#include "gh2g.h"
/* --------------------------------- MAIN ----------------------------------- */
int main(void)
{
double (*P_g)     (double x);
double (*P_h)     (double x);

double    a =    0.;
double    b =   0.6;
double   dx =  0.02;
double step = 0.001;
double    M =    0.;
/*-------------------------------- PROGRAM ---------------------------------- */
 P_g=  g;
 P_h=  h;

 clrscrn();
 printf(" Verify that g(x) >= h(x) on [%.3lf,%.3lf].\n\n\n", a, b);

 printf(" g : x-> %s\n\n", geq);
 printf(" h : x-> %s\n\n", heq);
 printf(" To see the graph of g and h, open the file \"f_Df.plt\" with Gnuplot.\n\n");

                       /* plot [xmin:xmax] [ymin:ymax] */
   gplt_ghab( -.5,      /* xmin  */
              1.5,      /* xmax  */
               0,      /* ymin  */
               2,      /* ymax  */
               a,
               b,
             geq,
             heq,
      (*P_g),
      (*P_h)
              );
 getchar();

 clrscrn();
 printf(" Draw a typical vertical rectangle.\n\n");
 printf(" To see the graph of g and h, open the file \"f_Df.plt\" with Gnuplot.\n\n\n\n\n");

 printf(" Upper boundary  (g)            :   %s              \n",  geq     );
 printf(" lower boundary  (h)            :   %s              \n\n",heq     );
 printf(" The length of the rectangle is :  (%s) - (%s)      \n",  geq, heq);
 printf(" The width  of the rectangle is :    dx             \n"           );
 printf(" The Area   of the rectangle is : ((%s) - (%s)) * dx\n",  geq, heq);
 printf(" \n\n\n\n\n");

                       /* plot [xmin:xmax] [ymin:ymax] */
 gplt_areagh(-.5,      /* xmin  */
             1.5,      /* xmax  */
              0.,      /* ymin  */
              2.,      /* ymax  */
               a,
               b,
              dx,
            step,
          (*P_g),
          (*P_h)
              );
 getchar();

 clrscrn();
 printf(" If we apply \n\n\n");
 printf("    (%.3lf\n", b);
 printf(" int(      \n");
 printf("    (%.3lf%\n\n\n", a);

 printf(" to  : ((%s) - (%s)) * dx\n\n", geq, heq);
 printf(" We obtain a limit of sums of areas of vertical rectangles.\n\n\n");

               P_g = Areagh;
 M = simpson((*P_g),a,b,2*30000);

 printf("    (%.3lf\n", b);
 printf(" int(     [(%s) - (%s)] dx = %.12lf\n", geq,  heq, M);
 printf("    (%.3lf\n", a);

 printf("\n Press return to continue");
 getchar();

 return 0;
}

