/* f.h                    freeware                          xhunga@tiscali.fr */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void gplt_fab(
double xmin,
double xmax,
double ymin,
double ymax,
double a,
double b,
  char feq[TXT_EQ],
double (*P_f)(double x)
)
{
FILE   *fp;
char    FA[FILENAME] = "a";
char    FB[FILENAME] = "b";
double  t;

        fp = fopen("f_Df.plt","w");

fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis lt 8\n");
fprintf(fp," set grid\n\n");
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp,"%s",feq);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 1",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 1",FB);


fprintf(fp,"\n\n");
fprintf(fp," reset");

             fclose(fp);

        fp = fopen(FA,  "w");

t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a, t);
fprintf(fp," %0.6lf   %0.6lf\n", a, 0.0);

             fclose(fp);

        fp = fopen(FB,  "w");

t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b, t);
fprintf(fp," %0.6lf   %0.6lf\n", b, 0.0);

             fclose(fp);

}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void   gplt_areaf(
double xmin,
double xmax,
double ymin,
double ymax,
double a,
double b,
double r,
double step,
  char feq[TXT_EQ],
double (*P_f)(double x)
)
{
FILE   *fp;
char    FA[FILENAME] = "a";
char    FB[FILENAME] = "b";
char    FR[FILENAME] = "r";
char    FL[FILENAME] = "l";
double  t;
double  i;

        fp = fopen("f_Df.plt","w");
fprintf(fp,"#\n");
fprintf(fp,"# Worksheet for gp371w32.exe by xhunga bernard 06000 Nice France\n");
fprintf(fp,"#\n\n");
fprintf(fp," set zeroaxis lt 8\n");
fprintf(fp," set grid\n\n");
t = ( (*P_f)((a+b)/2.) )/2.;
fprintf(fp," set label \"%s\" at %0.3lf, %0.3lf\n\n", feq, (((a+b)/2)+ (2.5*r)),t);
t = (*P_f)((a+b)/2.) + 2. * r;
fprintf(fp," set label \"dx\" at %0.3lf, %0.3lf\n\n", ((a+b)/2.), t);
fprintf(fp," plot [%0.3lf:%0.3lf] [%0.3lf:%0.3lf] ",xmin,xmax,ymin,ymax);
fprintf(fp," \"%s\" with linesp lt 3 pt 1",FA);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 1",FB);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 9 pt 0",FR);
fprintf(fp,", ");
fprintf(fp," \"%s\" with linesp lt 3 pt 0",FL);
fprintf(fp,"\n\n");
fprintf(fp," reset");
             fclose(fp);


        fp = fopen(FA,  "w");
t = ((*P_f)(a)) ;
fprintf(fp," %0.6lf   %0.6lf\n", a, t);
fprintf(fp," %0.6lf   %0.6lf\n", a, 0.0);
             fclose(fp);


        fp = fopen(FB,  "w");
t = ((*P_f)(b)) ;
fprintf(fp," %0.6lf   %0.6lf\n", b, t);
fprintf(fp," %0.6lf   %0.6lf\n", b, 0.0);
             fclose(fp);


        fp = fopen(FR,  "w");
t = (*P_f)( (a+b)/2.) ;
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,       0.0);
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.+ (r ), 0.0);
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.+ (r ),   t);
fprintf(fp," %0.6lf   %0.6lf\n", (a+b)/2.,         t);
             fclose(fp);


        fp = fopen(FL,  "w");
i = a;
do{
   t = ((*P_f)(i)) ;
   fprintf(fp," %0.6lf   %0.6lf\n", i, t);
   i += step;
}while(i <=  b);
             fclose(fp);
}

