/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"

/***
 *  Function    :  strleft
 *
 *  Description :  Copy the first ... characters of a string.
 *		   Like strncpy but add a '\0' at the end of the output string.
 *
 *  Decisions   :  If given length > string length : normal strcpy
 *		   If given length <= 0 returns an empty string.
 *
 *  Parameters  :  out  char  *out_str     result
 *                 in   char  *in_str      in string
 *                 in   int   length       length to be copied
 *
 *  Return code :   pointer to result.
 *
 *  OS/Compiler :   All
 */

char *strleft( char *out_str, const char *in_str, int length )

{ char *ptr = out_str;

  if ( length <= 0 ) { *out_str = '\0';
    		       return out_str;
		     }

  while ( (*out_str++ = *in_str++) && -- length );

  if ( ! length ) *out_str = '\0';

  return ptr;
}

