/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)   */

#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "tools.h"
#include "bctools.h"
#include "key.h"
#include "bool.h"

int insert_mode = True;


/***
 *  Function    :   inputs
 *
 *  Description :   Input a string from keyboard
 *
 *  Parameters  :   in/out   char * data        default and result
 *                  in       int    maxLen      maximum length to accept
 *                  in       int    timeout     maximum time (seconds) waiting
 *                                              before a key is pressed
 *
 *
 *  Decisions   :   Valid keys:   Home         Begin of line
 *		                  End          End of line
 *                                Left/Right   One character left/right
 *		                  Insert       Toggle isert on/off
 *                                Delete       Delete current  character
 *                                BackSpace    Delete previous character
 *		                  Ctrl-home    Erase to begin-of-line
 *		                  Ctrl-end     Erase to end-of-line
 *                                Escape       Erase whole input
 *                                Enter        Accept input
 *
 *                  Default string is erase if another input is given.
 *                  (if any non-editing character is hit).
 *
 *                  If no key is hit before timeout (in seconds)
 *                  the function returns.
 *                  timeout -1 means no timeout.
 *                  timeout  0 means check for type-ahead.
 *
 *  Return      :   length of input
 *                  -1 if time-out
 *
 *  OS/Compiler :   MS-DOS & Turbo-C
 ***/

int inputs( char *data, int maxLen, int timeout )
{
 int Xpos = wherex(), Ypos = wherey(), len = strlen( data ), oldLen = 0;
 char *curPos = data + len;
 int firstkey = True, x, y, c;
 struct text_info ti;

 gettextinfo( &ti );

 for (;;)
    {
     if ( len != oldLen )
        {
         gotoxy( Xpos, Ypos );
         cputs( data );
         for ( ; oldLen > len; oldLen-- ) cputs(" ");
         if ( oldLen < len ) oldLen = len;
         Ypos = min( Ypos, wherey() - (Xpos + len - 1) / ti.screenwidth );
        }

     if ( firstkey && (timeout >= 0) )
        {
         time_t now = time( NULL );  /* Gets system time */

         do if ( kbhit() ) timeout = -1;
         while ( difftime(time(NULL), now) < timeout );

         if ( timeout >= 0 ) return -1;
        }

 _setcursortype( insert_mode ? _NORMALCURSOR : _SOLIDCURSOR );

#pragma warn -sig
     for ( x = curPos - data + Xpos, y = Ypos;
           x > ti.screenwidth;
           x -= ti.screenwidth, y++
         );
     gotoxy( x, y );
#pragma warn .sig

     switch( c = getkey() )
     {
      case LEFT:
         if ( curPos > data ) curPos--;
         break;

      case RIGHT:
         if ( curPos < data + len ) curPos++;
         break;

      case HOME:
         curPos =  data;
         break;

      case END:
         curPos = data + len;
         break;

      case BACKSPACE:
         if ( curPos > data )
            {
             strcpy( curPos - 1, curPos );
             curPos--;
             len--;
            }
         break;

      case DEL:
         if ( curPos < data + len )
            {
             strcpy( curPos , curPos + 1 );
             len--;
            }
         break;

      case INSERT:
         insert_mode = ! insert_mode;
         _setcursortype( insert_mode ? _NORMALCURSOR : _SOLIDCURSOR );
         continue; /* break; */

      case ESC :
         *data = '\0';
         curPos = data;
         len = 0;
         break;

      case ENTER:
         cputs( "\r\n" );
         _setcursortype( _NORMALCURSOR );
         return len;

      case CTRL_END:
         *curPos = '\0';
         len = strlen( data );
         break;

      case CTRL_HOME:
         strcpy( data , curPos );
         curPos = data;
         len = strlen( data );
         break;

      default:
         if ( c > 255 )
            {
             buzzer();
             break;
            }

         if ( firstkey )
            {
             *data = '\0';
             curPos = data;
             len = 0;
             ungetch( c );
             break;
            }

         if ( ! insert_mode )
            {
             cprintf( "%c", c );
             *curPos++ = c;
             if ( curPos >= data + len )
                {
                 *curPos = '\0';
                 len++;
                }
             break;
            }

         if ( len == maxLen )
            {
             buzzer();
             break;
            }

         memmove( curPos + 1, curPos, strlen(curPos) + 1 );
         *curPos++ = c;
         len++;
         break;
      }

      firstkey = False;
    }
}
