PROGRAM More_Keys;
(* =============================================== *)
(*  IN this example, the interrupt handler code    *)
(*  is completely contained in the UNIT called     *)
(*  "MOREKEYU".  The unit's initialization part    *)
(*  installs the new interrupt, and its ExitProc   *)
(*  restores the original interrupt.  This is      *)
(*  totally invisible to your program -- just      *)
(*  USE the unit and that's all!                   *)
(* =============================================== *)

USES Crt,Dos,morekeyU;

  PROCEDURE Do_Demo;
  VAR
    CH, DH : Char;
  BEGIN
    ClrScr;
    WriteLn('KEYBOARD INTERRUPT DEMO "More Keys"');
    WriteLn('===================================');
    WriteLn;
    Write('Press various keys and combinations.  ');
    WriteLn('The <Alt> plus keypad combinations');
    Write('now work as in Appendix K of the TURBO ');
    WriteLn('3.0 manual.  ALSO, the <Alt>+number');
    Write('combinations are still available -- you ');
    WriteLn('must press <Alt><LeftShift>+number.');
    WriteLn('Hit <Esc> to end demo.');
    WriteLn;
    REPEAT
      DH := #0;
      CH := ReadKey;
      IF (CH = #0) AND KeyPressed THEN
        BEGIN
          DH := ReadKey;
          CASE DH OF
            #174 : WriteLn('<Alt><Home>');
            #175 : WriteLn('<Alt><Up>');
            #176 : WriteLn('<Alt><PgUp>');
            #177 : WriteLn('<Alt><GreyMinus>'); {*}
            #178 : WriteLn('<Alt><Left>');
            #179 : WriteLn('<Alt><Center>');    {*}
            #180 : WriteLn('<Alt><Right>');
            #181 : WriteLn('<Alt><GreyPlus>');  {*}
            #182 : WriteLn('<Alt><End>');
            #183 : WriteLn('<Alt><Down>');
            #184 : WriteLn('<Alt><PgDn>');
            #185 : WriteLn('<Alt><Ins>');
            #186 : WriteLn('<Alt><Del>');
            (* ================================== *)
            (* NOTE: The three keys marked with a *)
            (* {*} do NOT appear in the list in   *)
            (* Appendix K.  However, the scan     *)
            (* codes are logical in relation to   *)
            (* those that do appear.              *)
            (* ================================== *)
          END;
        END
      ELSE
        CASE CH OF
          #8  : Write(#8,' ',#8);
          #13 : WriteLn;
          #27 : ; {our QUIT signal}
          ELSE Write(CH);
        END;
    UNTIL (CH = #27) AND (DH = #0);
    {i.e., until you press <Esc> }
  END;

BEGIN
  Do_Demo;                       {show yer stuff!}
END.
