@ECHO OFF
::REM CHKBOOT.BAT -- ensures BOOT track not damaged, repairs if it is.

::REM last updated by Roedy Green of Canadian Mind Products 95/08/07
::REM Insert to this in AUTOEXEC.BAT to check BOOT.

REM Configure this line to point to where you installed the CMP utilities.

SET CMPDIR=C:\CMP

if not exist  %CMPDIR%\CDD!.com GOTO Missing

REM Switch to the C:\CMP drive and directory
%CMPDIR%\CDD!.com %CMPDIR%

if not exist  BOOTCHK.COM  GOTO Missing
if not exist  BOOTSAVE.COM GOTO Missing
if not exist  BOOTREST.COM GOTO Missing
if not exist  REBOOT.COM   GOTO Missing
GoTo KeepGoing

:Missing

Echo. Error ۲
Echo The following files must be installed in %CMPDIR%
Echo They are available on BIX or when you register BOOTSAVE.
Echo CDD!.com BOOTCHK.com BOOTSAVE.com BOOTREST.com and REBOOT.com
Echo.
pause
GoTo Done

:KeepGoing

IF NOT EXIST BOOT.SAV GoTo MakeIt

BOOTCHK.com BOOT.SAV /Q
IF NOT Errorlevel 1 GOTO DONE

::REM BOOT check failed:
::REM could be 2 reasons:

::REM 1. BOOT has been illegitimately tampered with

::REM 2. BOOT has been deliberately changed, by partition changes.
::REM    Clever user will have to abort, and delete %CMPDIR%\BOOT.SAV
::REM    or delete before before making changes. 
::REM    A new BOOT.SAV will be automatically
::REM    generated.  It should be copied to the rescue diskette.

::REM Warn consultants confounded by BOOTREST undoing their FDISK changes.

Echo.
Echo.To deliberately change BOOT, before you make your FDISK changes, you
Echo.must delete %CMPDIR%\BOOT.SAV.
Echo.See CHKBOOT.BAT or BOOT.TXT for more details.
Echo.
Echo.Abort now with Ctrl-Break Y if you do not wish to restore damaged
Echo BOOT track.
Echo.Normally you should just hit the SPACE BAR to repair BOOT or put it
Echo.back the way it used to be.  If you have made deliberate FDISK changes
echo.YOU MUST ABORT with Ctrl-Break Y and delete %CMPDIR%\BOOT.SAV.
Echo.
Pause

::REM save "corrupted" current contents of BOOT just in case
BOOTSAVE.COM BOOT.OLD /Q

::REM try restoring
BOOTREST.COM BOOT.SAV /Q
IF NOT Errorlevel 1 GOTO Reboot
Echo BOOT is still corrupted
Echo.
Pause

:Reboot
Reboot.Com

:MakeIt

::REM Build a NEW BOOT.SAV file
Echo Recreating %CMPDIR%\BOOT.SAV file.
BOOTSAVE.COM BOOT.SAV /Q
Echo You might also want to create a new A: Rescue floppy boot disk soon
Echo Use BOOTSAVE A:\BOOT.SAV
Echo.
Pause

:DONE
::REM -30-
