#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*          Simulation shell         */
/*             dialog box            */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <string.h>
#include <io.h>
#include "toolhelp.h"
#include "globals.h"
#include "defines.h"
#include "strtbl.h"
#include "gwsim.h"
#include "simgvar.h"
#include "basic.h"
#include "gep2.h"

#pragma alloc_text( CODE11, Execute, WatchDosApp, CheckSimEng )

#define HFILE_ERROR -1

/* calls the simulation engine to carry out the current simulation */

HANDLE hSimTask;

int Execute( HWND hWnd, HANDLE hInst )
{
 int hFile, nRc;
 char szString[256];
 char *ptr;


 lstrcpy( (LPSTR) CommandLine, (LPSTR) GepasiIni );
 ptr = strrchr( CommandLine, '\\' );
 *(ptr+1) = '\0';
 GetTempFileName( 0, (LPSTR) "GEP", 0, (LPSTR) TempFile );
 hFile = _lopen( (LPSTR) TempFile, OF_WRITE | OF_SHARE_COMPAT );
 nRc = _lwrite( hFile, FileName, lstrlen( FileName ) );
 nRc += _lwrite( hFile, (LPSTR) "\n", 1 );
 _lclose( hFile );
 if( nRc < ( lstrlen( (LPSTR) FileName ) +1 ) )
 {
  LoadString(hInst, IDS_ERR_NO_TEMP, szString, sizeof(szString));
  MessageBeep( MB_OK );
  MessageBox( hWnd, szString, FileTitle, MB_ICONINFORMATION );
  unlink( TempFile );
  return IDS_ERR_NO_TEMP;
 }
 if( options.debug )
 {
  lstrcat( (LPSTR) CommandLine, (LPSTR) "GEPASI_R.BAT " );
  GetModuleFileName( hInst, (LPSTR) szString, sizeof( szString ) );
  ptr = strrchr( szString, '\\' );
  *(ptr+1) = '\0';
  lstrcat( (LPSTR) CommandLine, (LPSTR) szString );
 }
 lstrcat( (LPSTR) CommandLine, (LPSTR) "GEPASI.EXE " );
 lstrcat( (LPSTR) CommandLine, (LPSTR) TempFile );
 lstrcat( (LPSTR) CommandLine, (LPSTR) " -d" );
 if( options.debug )
 {
  lstrcpy( (LPSTR) LogFile, (LPSTR) FileName );
  if ( ptr = strrchr( LogFile, '.' ) ) strcpy( ptr, ".LOG" );
  else strcat( ptr, ".LOG" );
  lstrcat( (LPSTR) CommandLine, (LPSTR) " " );
  lstrcat( (LPSTR) CommandLine, (LPSTR) LogFile );
  MessageBox( hWnd, (LPSTR) CommandLine, FileTitle, MB_ICONINFORMATION );
 }
 nRc = WinExec( (LPSTR) CommandLine, SW_SHOWMINIMIZED );
 if( nRc<32 ) ErrorHandler( hInst, nRc );
 else
 {
  if( ! WatchDosApp( (HANDLE) nRc, fpCheckSimEng ) )
  {
   MessageBeep( MB_OK );
   MessageBox( hWnd, "Unable to create watch callback function.\nPlease report to developer.", (LPSTR) "Execute()", MB_ICONEXCLAMATION );
   return -1;
  }
  EnableMenuItem( hMenu, IDM_GO, MF_GRAYED );
  EnableWindow( hButton2, FALSE );
  DrawMenuBar( hWnd );
  running = 1;
 }

 return nRc;
}


int WatchDosApp( HANDLE hApp, FARPROC fpCheck )
{
 TASKENTRY TaskStruct;
 int nRc;

 /* initialize the TASKENTRY structure	*/
 TaskStruct.dwSize = (DWORD) sizeof( TASKENTRY );

 if ( TaskFirst( &TaskStruct ) )
  do
   if( TaskStruct.hInst == hApp ) break;
  while ( TaskNext( &TaskStruct ) );
 else return 1;
 hSimTask = TaskStruct.hTask;
 nRc = NotifyRegister( NULL , (LPFNNOTIFYCALLBACK) fpCheck, NF_NORMAL );
 return nRc;
}

/*
  Callback function that is called when timer goes off.
  Checks if the Simulation Engine is still running. If
  not plots the file and/or lists the report and/or the
  debug log
*/

BOOL FAR PASCAL CheckSimEng( WORD wID, DWORD dwData)
{
 /* return if task is not exiting			*/
 if( wID == NFY_EXITTASK )
 {
  /* post the appropriate message			*/
  PostMessage( hWndMain, WM_USER+2, 0, 0 );
  /* signal that notification was processed	*/
  return 1;
 }
 else return 0;
}

void SimEnd( void )
{
 int nRc;
 char *ptr;
 TASKENTRY TaskStruct;

 /* initialize the TASKENTRY structure	*/
 TaskStruct.dwSize = (DWORD) sizeof( TASKENTRY );
 /* do nothing if the application that exited is not the simulation engine	*/
 if( ! TaskFindHandle( &TaskStruct, hSimTask ) )
 {
  /* unregister the callback procedure				*/
  if( ! NotifyUnRegister( NULL ) )
  {
   MessageBeep( MB_OK );
   MessageBox( hWndMain, (LPSTR) "Couldn't NotifyUnRegister hTask.\nPlease report to developer.", (LPSTR) "SimEnd()", MB_ICONEXCLAMATION );
  }

  /* enable the Run selections						*/
  EnableMenuItem( hMenu, IDM_GO, MF_ENABLED );
  EnableWindow( hButton2, TRUE );
  DrawMenuBar( hWndMain );
  InvalidateRect( hWndMain, NULL, TRUE );
  running = 0;

  /* ask user if he wants to read the debug log		*/
  if( options.debug )
  {
   lstrcpy( (LPSTR) CommandLine, (LPSTR) "notepad " );
   lstrcat( (LPSTR) CommandLine, (LPSTR) LogFile );
   nRc = WinExec( (LPSTR) CommandLine, SW_SHOWNORMAL );
   if( nRc<32 ) ErrorHandler( hInst, nRc );
  }

  /* ask user if he wants to read the report file	*/
  if( options.txt )
  {
   LoadString(hInst, IDS_REPORTQUERY, szString, sizeof(szString));
   MessageBeep( MB_ICONQUESTION );
   nRc = MessageBox(hWndMain, (LPSTR) szString, (LPSTR) FileTitle, MB_ICONQUESTION | MB_YESNO );
   if( nRc == IDYES )
   {
    lstrcpy( (LPSTR) CommandLine, (LPSTR) "notepad " );
    lstrcat( (LPSTR) CommandLine, (LPSTR) FileName );
    if ( ( ptr = strrchr( CommandLine, '.' ) ) != NULL ) strcpy( ptr, ".TXT" );
    else strcat( CommandLine, ".TXT" );
    nRc = WinExec( (LPSTR) CommandLine, SW_SHOWNORMAL );
    if( nRc<32 ) ErrorHandler( hInst, nRc );
   }
  }
 }
}