        PAGE    60,132
        TITLE   Watchdog - resets machine when carrier is lost
;
; WATCHDGS.COM  3/6/88  Original by James R. Reinders
;
;  Update/Modification History (reverse order):
;
;       8/15/84 - Original program.
;       3/06/88 - Doug Azzarito: WATCHDGS command specifically written for
;                 ALLOY PC-SLAVE systems and other non-standard MS-DOS
;                 computers.  Changed reboot command from direct jump
;                 (FFFF:0000) to an INT 19H.  Use this only if WATCHDOG.COM
;                 does not properly reboot your system.
;
;       The IBM Macro Assembler and Link will produce WATCHDGS.EXE
;       which must be converted to a .COM program by the DOS
;       EXE2BIN command:
;
;       C\> EXE2BIN WATCHDGS.EXE WATCHDGS.COM
;
TRUE    EQU     1
FALSE   EQU     0

CSEG    SEGMENT 'CODE'
        ASSUME  CS:CSEG
        ORG     100H            ; SET UP FOR .COM CONVERSION

INIT    PROC    FAR             ; WE'RE AN INTERRUPT ROUTINE
        JMP     SHORT INITIAL   ; SO WE HAVE TO SET UP FIRST

START   PROC    FAR     ; Start of main routine - Timer (18.2 times per second)
        ASSUME  CS:CSEG,DS:CSEG

        PUSH    AX
        MOV     AL,CS:101H
        OR      AL,AL
        JZ      NOWAY
        PUSH    DX

        MOV     DX,2FEH
        IN      AL,DX
        RCL     AL,1
        JNC     LOSTCARR

        POP     DX
NOWAY:  POP     AX

        DB      0EAH            ; JMP old timer routine
WAS1Co  DW      0
WAS1Cs  DW      0

LOSTCARR:
        INT     19H

START   ENDP

BUFFER  DB      'Watchdog for PC-Slave v1.0  03/06/88 by James R. Reinders.'
        DB      13,10
        DB      'PC-Slave mods by Doug Azzarito'
        DB      13,10,'$'

INITIAL:
        MOV     AX,CS
        MOV     DS,AX

        MOV     DX,OFFSET BUFFER
        MOV     AH,9
        INT     21H     ; PRINT GREETING

        MOV     AX,351CH
        INT     21H

DOWHAT: XOR     AL,AL
        MOV     SI,05DH
        CMP     BYTE PTR [SI],'O'
        JNZ     ONONON
        CMP     BYTE PTR [SI+1],'F'
        JNZ     ONONON
        CMP     BYTE PTR [SI+2],'F'
        JNZ     ONONON
        CMP     BYTE PTR [SI+3],' '
        JZ      OFFOFF

ONONON: INC     AL
        CMP     WORD PTR ES:[BX],2E50H
        JNZ     PUTIN
OFFOFF: CMP     WORD PTR ES:[BX],2E50H
        MOV     DX,OFFSET NODOG
        JNZ     PBYE

        DEC     BX
        MOV     ES:[BX],AL

        MOV     DX,OFFSET ACTIVE
        OR      AL,AL
        JNZ     PBYE
        MOV     DX,OFFSET NACTIVE

PBYE:   MOV     AH,9
        INT     21H
        INT     20H

PUTIN:  MOV     AX,ES
        MOV     WAS1Cs,AX
        MOV     CS:WAS1Co,BX

        MOV     AX,CS
        MOV     DS,AX

        MOV     DX,OFFSET START
        MOV     AX,251CH  ; DOS ROUTINE TO RESET INT. VECTOR
        INT     21H

        MOV     DX,OFFSET INSTAL
        MOV     AH,9
        INT     21H
;
        MOV     DX,OFFSET BUFFER ; LAST ADDRESS HERE
        INT     27H     ; TERMINATE BUT STAY RESIDENT
INIT    ENDP


INSTAL  DB      'Watchdog installed and activated.',13,10,'$'
ACTIVE  DB      'Watchdog activated.',13,10,'$'
NACTIVE DB      'Watchdog deactivated.',13,10,'$'
NODOG   DB      'Watchdog not present OR'
        DB      ' another time utility loaded since watchdog.'
        DB      13,10,'$'

CSEG    ENDS
        END     INIT
