{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'funs.int'}
{$include: 'fs_pkg.int'}
{$include: 'database.int'}
{$include: 'load.int'}
{$include: 'sutils.int'}
{$include: 'script3.int'}

IMPLEMENTATION OF script3;

USES types,globals,utils,funs,fs_pkg,database,load,sutils;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the PASASM assembler utilities package***}
{$include: 'pasasm.int'}

procedure bbs3{consts s : lstring; var str : lstring};
var
  i,j,k : integer;
  i4,j4 : integer4;
  next_state : task;
  p : para;
  h : mailhead;
  fl : boolean;

begin
  next_state:=succ(q[wx].state);
  case q[wx].state of
  userlog:
    [if (q[wx].count<userlog_entries) and then
        ((q[wx].index<>userlog_next) or (q[wx].count=0)) then
       [q[wx].count:=q[wx].count+1; q[wx].index:=q[wx].index-1;
        if q[wx].index<=0 then q[wx].index:=userlog_entries;
        dbg_userlog(q[wx].index,userlog_buffer);
	if ivalue(userlog_buffer.userlevel)>=priv_log then
          display(userlog_line_txt)
        else
          [if disk2u(ivalue(userlog_buffer.userid)) and then
	      ivalue(q[wx].your.userlevel)>=priv_log
             then display(userlog_line_txt)];
        next_state:=userlog]
     else
       next_state:=main_menu];
  sendmail_prompt: prompt_with(file_number_txt);
  sendmail_to:
    [make_number(s,str);
     if number_query(str,1,largest_member_number,i) then
       [q[wx].correspondent:=i;
        if disk2u(i) then
          [i:=ivalue(q[wx].your.mbx_count);
           j:=ivalue(q[wx].your.mbx_max);
           if i<max_max_mbx and then ((i<j) or (q[wx].level=9))
             then display(to_from_txt)
             else [display(no_slots_txt); next_state:=main_menu]]
        else
          [display(bad_userid_txt); next_state:=main_menu]]
     else
       [display(bad_userid_txt); next_state:=main_menu]];
  correct3: prompt_with(cor_txt);
  sendmail_subject:
    if agree(s) then
      [prepare_header; prompt_with(enter_subject_txt)]
    else
      [prompt_with(file_number_txt); next_state:=sendmail_to];
  enter_subject:
    if s.len=0 then
      [display(msg_cancelled_txt); next_state:=sendmail_cancel]
    else
      [p:=newpara(ss[22]); concat(p^.msg,': '); {Subject: }
       cat(p^.msg,s); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       p:=newpara(null); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       if q[wx].flag
         then display(enter_body_txt)
         else [prompt_with(which_canned_txt); next_state:=canned1]];
  enter_body1:
    [q[wx].send_line_count:=1; q[wx].count:=1; prompt_with(send_line_txt)];
  enter_body2:
    if s[0]=chr(0) then
      [if q[wx].return_state=junk2 then q[wx].index:=largest_member_number;
       display(msg_cancelled_txt); next_state:=sendmail_cancel]
     else
      [p:=newpara(s); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       q[wx].send_line_count:=q[wx].send_line_count+1;
       q[wx].count:=q[wx].count+1;
       prompt_with(send_line_txt)];
  enter_body3:
    if s[0]=chr(0) then
      [prompt_with(send_menu_txt); next_state:=sendmail_fork]
    else
      [p:=newpara(s); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       q[wx].send_line_count:=q[wx].send_line_count+1;
       q[wx].count:=q[wx].count+1;
       if q[wx].send_line_count<=msg_line_limit or else q[wx].level=9 then
         [prompt_with(send_line_txt); next_state:=enter_body3]
       else
         [prompt_with(send_menu_txt); next_state:=sendmail_fork]];
  sendmail_menu: prompt_with(send_menu_txt);
  sendmail_fork:
    [next_state:=sendmail_menu;
     if str=null then
       display(dunno_txt)
     else if str[1]=mn[10][1] {?} or else eq(str,ss[40]) {HELP} then
       display(send_menu_list_txt)
     else if str.len=1 and then str[1]=mn[10][2] {A} then
       [if q[wx].send_line_count<=msg_line_limit or else q[wx].level=9 then
          [q[wx].count:=q[wx].send_line_count;
           prompt_with(send_line_txt); next_state:=enter_body3]
        else display(too_long_txt)]
     else if str.len=1 and then str[1]=mn[10][9] {D} then
       [prompt_with(delete_line_txt); next_state:=sendmail_delete1]
     else if str.len=1 and then str[1]=mn[10][3] {E} then
       [prompt_with(edit_which_txt); next_state:=sendmail_edit1]
     else if str.len=1 and then str[1]=mn[10][4] {H} and then
          q[wx].return_state<>junk2 then
       [q[wx].holding:=true;
        if q[wx].return_state=pubmail5
          then q[wx].hold_target:=-1
          else q[wx].hold_target:=q[wx].correspondent;
        display(msg_held_txt); next_state:=q[wx].return_state]
     else if str.len=1 and then str[1]=mn[10][5] {L} then
       [prompt_with(what_line_txt); next_state:=sendmail_list]
     else if str.len=1 and then str[1]=mn[10][6] {R} then
       [prompt_with(replace_line_txt); next_state:=sendmail_replace1]
     else if str.len=1 and then str[1]=mn[10][7] {S} then
       case q[wx].return_state of
         pubmail5 : [display(pub_sending_txt); next_state:=sending];
         junk2 : [q[wx].index:=0; q[wx].holding:=false;
                  display(sending_txt); next_state:=junk2];
         otherwise
           [if disk2u(q[wx].correspondent) then
              [display(sending_txt); next_state:=sending]
            else
	      [q[wx].dos_err:=-2; {corrupt members file?}
	       display(mail_not_sent_txt)]];
       end {case}
     else if str.len=1 and then str[1]=mn[10][8] {X} then
       [if q[wx].return_state=junk2 then q[wx].index:=largest_member_number;
        display(msg_cancelled_txt); next_state:=sendmail_cancel]
     else if eq(str,ss[37]) or else eq(str,ss[38]) or else eq(str,ss[39]) then
       {BYE, OFF, EXIT}
       next_state:=snip
     else if str.len>2 and then
             str[1]=mn[7][2] {/} and then str[2]=mn[7][4] {P} then {/P}
       SlashP(s,str)
     else
       [prompt_with(send_menu_txt); next_state:=sendmail_fork]];
  sendmail_list:
    if s=null or else number_query(s,1,q[wx].send_line_count-1,i) then
      [if s=null then i:=1;
       p:=q[wx].msg_first; q[wx].count:=i;
       for j:=1 to i+4 do
         if p=nill then [q[wx].count:=0; break] else p:=p^.link;
       q[wx].msg_ptr:=p; display(sendmail_line_txt)]
    else
      [display(bad_line_number_txt); next_state:=sendmail_menu];
  sendmail_list2:
    [if q[wx].msg_ptr<>nill then q[wx].msg_ptr:=q[wx].msg_ptr^.link;
     if q[wx].msg_ptr=nill then
       [prompt_with(send_menu_txt); next_state:=sendmail_fork]
     else
       [q[wx].count:=q[wx].count+1;
        display(sendmail_line_txt); next_state:=sendmail_list2]];
  sendmail_edit1:
    if number_query(s,1,q[wx].send_line_count-1,i) then
      [p:=q[wx].msg_first; q[wx].count:=i;
       for j:=1 to i+4 do
         if p=nill then [q[wx].count:=0; break] else p:=p^.link;
       q[wx].msg_ptr:=p; display(sendmail_line_txt)]
    else
      [display(bad_line_number_txt); next_state:=sendmail_menu];
  sendmail_edit2: prompt_with(enter_new_line_txt);
  sendmail_edit3:
    [kopylst(s,q[wx].msg_ptr^.msg);
     prompt_with(send_menu_txt); next_state:=sendmail_fork];
  sendmail_replace1:
    if number_query(s,1,q[wx].send_line_count-1,i) then
      [p:=q[wx].msg_first; q[wx].count:=i;
       for j:=1 to i+4 do
         if p=nill then [q[wx].count:=0; break] else p:=p^.link;
       q[wx].msg_ptr:=p; display(sendmail_line_txt)]
    else
      [display(bad_line_number_txt); next_state:=sendmail_menu];
  sendmail_replace2: prompt_with(text_old_txt);
  sendmail_replace3:
    [if q[wx].verify_data=nill
       then q[wx].verify_data:=newpara(s)
       else kopylst(s,q[wx].verify_data^.msg);
     prompt_with(text_new_txt)];
  sendmail_replace4: {msg_ptr = original text, verify_data = old, s = new}
    [if q[wx].msg_ptr<>nill and then q[wx].verify_data<>nill then
       [k:=0;
        for i:=1 to ord(q[wx].msg_ptr^.msg.len) do begin
          fl:=true;
          for j:=1 to ord(q[wx].verify_data^.msg.len) do
            if i+j-1>ord(q[wx].msg_ptr^.msg.len) or else
               q[wx].msg_ptr^.msg[i+j-1]<>q[wx].verify_data^.msg[j]
              then [fl:=false; break];
          if fl then
            [k:=i; break];
        end {for};
        if fl then
          [copylst(q[wx].msg_ptr^.msg,str);
           if k+ord(s.len)-1<=UPPER(str) then
             [if str.len+s.len-q[wx].verify_data^.msg.len>wrd(UPPER(str)) then
                str.len:=wrd(UPPER(str))-s.len+q[wx].verify_data^.msg.len;
              replace(str,s,k,ord(q[wx].verify_data^.msg.len));
              kopylst(str,q[wx].msg_ptr^.msg)]]];
     prompt_with(send_menu_txt); next_state:=sendmail_fork];
  sendmail_delete1:
    if number_query(s,1,q[wx].send_line_count-1,i) then
      [p:=q[wx].msg_first; q[wx].count:=i;
       for j:=1 to i+4 do
         if p=nill then [q[wx].count:=0; break] else p:=p^.link;
       q[wx].msg_ptr:=p; display(sendmail_line_txt)]
    else
      [display(bad_line_number_txt); next_state:=sendmail_menu];
  sendmail_delete2: prompt_with(cor_txt);
  sendmail_delete3:
    if agree(s) and then q[wx].count>0 then
      [if q[wx].send_line_count<=2 then
         [if q[wx].return_state=junk2 then q[wx].index:=largest_member_number;
          display(msg_cancelled_txt); next_state:=sendmail_cancel]
       else
         [p:=q[wx].msg_first;
          for j:=1 to q[wx].count+3 do
            if p=nill then break else p:=p^.link;
          if p<>nill and then p^.link<>nill then
            [q[wx].msg_ptr:=p^.link; p^.link:=q[wx].msg_ptr^.link;
	     if p^.link=nill then q[wx].msg_last:=p;
             display(line_deleted_txt);
             dispara(q[wx].msg_ptr); q[wx].msg_ptr:=nill;
             q[wx].send_line_count:=q[wx].send_line_count-1];
          next_state:=sendmail_menu]]
    else
     [prompt_with(send_menu_txt); next_state:=sendmail_fork];
  sending:
    [q[wx].holding:=false; eval(disk2u(q[wx].correspondent)); {OK if false}
     if q[wx].return_state=pubmail5 then
       [if not q[wx].pm^.holdem or else
           q[wx].pm^.memberid=q[wx].userid or else q[wx].level=9 then
          [if dbp_pubmail(q[wx].msg_first,' ')
             then [q[wx].msg_first:=nill; q[wx].msg_last:=nill;
                   display(pubmail_sent_txt)]
             else display(mail_not_sent_txt)]
        else
          [if dbp_pubmail(q[wx].msg_first,'H')
             then [q[wx].msg_first:=nill; q[wx].msg_last:=nill;
                   display(pubmail_held_txt)]
             else display(mail_not_sent_txt)];
        if q[wx].current_msg=0
          then next_state:=q[wx].return_state
          else next_state:=pub_rfb4]
     else
       [if sendmsg then
          [display(mail_sent_txt);
           if q[wx].return_state=readmail_menu
             then next_state:=reply_deletes
             else next_state:=q[wx].return_state]
        else
          [display(mail_not_sent_txt); next_state:=sendmail_menu]]];
  reply_deletes:
    if auto_delete then
      [q[wx].mbx_ptr^.deleted:=true; q[wx].mail_mod:=true;
       display(msg_deleted_txt); next_state:=which_msg_menu]
    else
      next_state:=q[wx].return_state;
  sendmail_cancel:
    [q[wx].holding:=false;
     disparas(q[wx].msg_first); q[wx].msg_last:=nill; q[wx].msg_ptr:=nill;
     next_state:=q[wx].return_state];
  mail_gimme1:
    [i4:=mem_avl-lhc; j4:=mbi; i4:=i4-j4;
     if fs_eof(wx) then {done reading mail}
       [if encode(str,q[wx].index:1) then kopystr(str,q[wx].my.mbx_count);
        fs_close(wx);
        if q[wx].my.junk[1]<>' '
          then next_state:=mail_gimme1j
          else next_state:=which_msg_menu]
     else if i4<(mem_avl div 20) then {running out of memory}
       [if encode(str,q[wx].index:1) then kopystr(str,q[wx].my.mbx_count);
        fs_close(wx);
        display(ofl_txt); next_state:=which_msg_menu]
     else if fs_gets(wx,str)<>0 or else (not decode(str,q[wx].count)) then
{damaged mail file}
       [if encode(str,q[wx].index:1) then kopystr(str,q[wx].my.mbx_count);
        fs_close(wx); q[wx].mail_mod:=true;
        q[wx].count:=14; display(file_error_txt);
        if q[wx].my.junk[1]<>' '
          then next_state:=mail_gimme1j
          else next_state:=which_msg_menu]
     else {good letter to read}
       [q[wx].index:=q[wx].index+1;
        newhead(h); h^.head_link:=nil;
        h^.text_first:=nill; h^.text_last:=nill;
        h^.index:=q[wx].index; h^.deleted:=false;
        if q[wx].mbx_first=nil then
          [q[wx].mbx_first:=h; q[wx].mbx_last:=h]
        else
          [q[wx].mbx_last^.head_link:=h; q[wx].mbx_last:=h]]];
  mail_gimme2:
    if fs_eof(wx) or else q[wx].count=0 then
      [q[wx].current_msg:=q[wx].index;
       if q[wx].current_msg=1
         then q[wx].mbx_ptr:=q[wx].mbx_first
         else q[wx].mbx_ptr:=q[wx].mbx_ptr^.head_link;
       parse_header(q[wx].mbx_ptr^.text_first);
       display(msg_header_txt); next_state:=mail_gimme1]
    else
      [if fs_gets(wx,str)=0
         then q[wx].count:=q[wx].count-1
         else q[wx].count:=0;
       fSmall:=true; p:=newpara(str); fSmall:=false;
       if q[wx].mbx_last^.text_first=nill
         then q[wx].mbx_last^.text_first:=p
         else q[wx].mbx_last^.text_last^.link:=p;
       q[wx].mbx_last^.text_last:=p;
       next_state:=mail_gimme2];
  mail_gimme1j:
    [kopylst(mailpath,str);
     if q[wx].my.junk[1]='J'
       then konkat(str,d_junk)
       else konkat(str,d_new);
     q[wx].my.junk[1]:=' '; q[wx].mail_mod:=true;
     q[wx].count:=fs_openr(wx,str);
     if q[wx].count=0 then {file opened OK}
       next_state:=mail_gimme1
     else
       [fs_close(wx);
        if q[wx].index>0 {index = no. of messages all told}
          then [prompt_with(which_msg_txt); next_state:=which_msg_fork]
          else [display(no_mail_txt); next_state:=main_menu]]];
  readmail_header:
    [q[wx].current_msg:=q[wx].current_msg+1;
     if q[wx].current_msg>q[wx].count then
       [prompt_with(which_msg_txt); next_state:=which_msg_fork]
     else
       [if q[wx].current_msg=1
          then q[wx].mbx_ptr:=q[wx].mbx_first
          else q[wx].mbx_ptr:=q[wx].mbx_ptr^.head_link;
        parse_header(q[wx].mbx_ptr^.text_first);
        if q[wx].mbx_ptr^.deleted
          then display(msg_header_deleted_txt)
          else display(msg_header_txt);
        next_state:=readmail_header]];
  which_msg_menu: prompt_with(which_msg_txt);
  which_msg_fork:
    [next_state:=which_msg_menu;
     if s=null or else str[1]=mn[8][3] {Q} then
       [if q[wx].level<9
          then [display(room_for_txt); next_state:=main_menu]
          else next_state:=main_menu]
     else if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if s[1]=mn[8][1] {?} then
       [q[wx].current_msg:=0; q[wx].count:=ivalue(q[wx].my.mbx_count);
        display(msg_title_txt); next_state:=readmail_header]
     else if number_query(s,1,ivalue(q[wx].my.mbx_count),i) then
       [q[wx].current_msg:=i;
        q[wx].mbx_ptr:=q[wx].mbx_first;
        while q[wx].mbx_ptr^.index<>q[wx].current_msg do
          q[wx].mbx_ptr:=q[wx].mbx_ptr^.head_link;
        if q[wx].mbx_ptr^.deleted then
          [prompt_with(undelete_prompt_txt); next_state:=undelete]
        else
          [display(fetching_txt); next_state:=readtext]]
     else
       display(invalid_msg_txt)];
  undelete:
    if nagree(s) then
      [q[wx].mbx_ptr^.deleted:=false; display(msg_undeleted_txt)]
    else
      [prompt_with(which_msg_txt); next_state:=which_msg_fork];
  fetching: display(fetching_txt);
  readtext:
    [parse_header(q[wx].mbx_ptr^.text_first);
     display(q[wx].mbx_ptr^.text_first)];
  readmail_menu: prompt_with(read_menu_txt);
  readmail_fork:
    [next_state:=readmail_menu;
     if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str=null then
       [prompt_with(which_msg_txt); next_state:=which_msg_fork]
     else if str[1]=mn[11][1] {?} then
       [prompt_with(read_menu_txt); next_state:=readmail_fork]
     else if str.len=1 and then str[1]=mn[11][2] {B} then
       [if q[wx].level<priv_br then
          display(read_access_txt)
        else if disk2u(q[wx].correspondent) then
          [display(browse_txt);
           q[wx].return_state:=readmail_menu; next_state:=browse_qs1]
        else display(bad_userid_txt)]
     else if str.len=1 and then str[1]=mn[11][3] {D} then
       [q[wx].mbx_ptr^.deleted:=true; q[wx].mail_mod:=true;
        display(msg_deleted_txt); next_state:=which_msg_menu]
     else if str.len=1 and then str[1]=mn[11][4] {R} then {Reply to private}
       [q[wx].return_state:=readmail_menu;
        if disk2u(q[wx].correspondent) then
	  [if q[wx].level<priv_reply then
	     display(read_access_txt)
	   else if q[wx].holding then
	     [if q[wx].correspondent=q[wx].hold_target
		then [display(send_private_txt); next_state:=sendmail_menu]
		else display(hold_error_txt)]
	   else if ivalue(q[wx].your.mbx_count)<ivalue(q[wx].your.mbx_max)
		   or else q[wx].level=9 then
	     [q[wx].flag:=true; {normal reply}
	      display(send_private_txt); next_state:=reply1]
	   else
	     display(no_slots_txt)]
	else
          display(user_deleted_txt)]
     else if str.len=1 and then str[1]=mn[11][5] {S} then {See it again}
       [display(fetching_txt); next_state:=readtext]
     else if str.len>2 and then
             str[1]=mn[7][2] {/} and then str[2]=mn[7][4] {P} then {/P}
       SlashP(s,str)
     else if q[wx].level=9 then begin
     if str='!C' and then (not q[wx].holding) then {canned reply}
       [q[wx].return_state:=readmail_menu;
        if disk2u(q[wx].correspondent) then
	  [q[wx].flag:=false; {canned reply}
	   display(send_private_txt); next_state:=reply1]
	else
          display(user_deleted_txt)]
     else if str='!D' then
       [if disk2u(q[wx].correspondent) then
          [q[wx].return_state:=readmail_menu;
           prompt_with(user_delete_txt); next_state:=delete_user2]
        else
          [display(bad_userid_txt); next_state:=readmail_menu]]
     else if str='!L' then
       [if disk2u(q[wx].correspondent) then
          [q[wx].return_state:=readmail_menu;
           prompt_with(enter_level_txt); next_state:=change_level2]
        else
          [display(bad_userid_txt); next_state:=readmail_menu]]
     else if str='!M' then
       [if disk2u(q[wx].correspondent) then
          [q[wx].return_state:=readmail_menu;
           prompt_with(mbx_size_txt); next_state:=change_mbx2]
        else
          [display(bad_userid_txt); next_state:=readmail_menu]]
     else if str='!T' then
       [if disk2u(q[wx].correspondent) then
          [q[wx].return_state:=readmail_menu;
           prompt_with(reset_time_txt); next_state:=reset_time]
        else
          [display(bad_userid_txt); next_state:=readmail_menu]]
     else [prompt_with(which_msg_txt); next_state:=which_msg_fork] end
     else [prompt_with(which_msg_txt); next_state:=which_msg_fork]];
  reply1: display(to_from_txt);
  reply2:
    [if not eq2(q[wx].msg_subject^.msg,ss[49]) {Re:} then
       [copylst(ss[49],str); cat(str,q[wx].msg_subject^.msg);
        kopylst(str,q[wx].msg_subject^.msg)];
     display(subject_txt)];
  reply2a: prompt_with(cor_txt);
  reply2b:
    if s.len>3 then
      [kopylst(s,q[wx].msg_subject^.msg);
       display(subject_txt); next_state:=reply2a]
    else if agree(s) then
       next_state:=reply3
    else
       prompt_with(enter_subject_txt);
  reply2c:
    if s[0]=chr(0)
      then [display(msg_cancelled_txt); next_state:=sendmail_cancel]
      else kopylst(s,q[wx].msg_subject^.msg);
  reply3:
    [prepare_header;
     p:=newpara(ss[22]); concat(p^.msg,': '); {Subject: }
     cat(p^.msg,q[wx].msg_subject^.msg);
     q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
     p:=newpara(null); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
     if q[wx].flag
       then [display(enter_body_txt); next_state:=enter_body1]
       else prompt_with(which_canned_txt)];
  canned1:
    if str=null or else (not filename_ok(str)) then
      [display(msg_cancelled_txt); next_state:=sendmail_cancel]
    else
      [q[wx].count:=fs_openr(wx,str);
       if q[wx].count=0 then
         q[wx].send_line_count:=1
       else
         [fs_close(wx);
          display(msg_cancelled_txt); next_state:=sendmail_cancel]];
  canned2:
    if fs_eof(wx) then
      [fs_close(wx);
       prompt_with(send_menu_txt); next_state:=sendmail_fork]
    else
      [p:=newpara(null); q[wx].msg_last^.link:=p; q[wx].msg_last:=p;
       q[wx].send_line_count:=q[wx].send_line_count+1;
       q[wx].count:=fs_gets(wx,p^.msg);
       if q[wx].count=0 then
         [expand_tabs(p^.msg); init_fx;
          if not substitute(p^.msg) then
            [kopylst(p^.msg,str); eval(substitute(str));
             kopylst(str,p^.msg)];
          next_state:=canned2]
       else
         [fs_close(wx);
          display(io_error_txt); next_state:=sendmail_menu]];
  pubmail1: {entry to public mail from the main menu}
    [q[wx].pm:=pubmail;
     if q[wx].pm=nil then
       next_state:=main_menu
     else if see_pub then
       display(pubmail_line_txt)];
  pubmail2: {display one pubmail header and loop}
    [repeat q[wx].pm:=q[wx].pm^.link until q[wx].pm=nil or else see_pub;
     if q[wx].pm=nil
       then display(pubmail_trailer_txt)
       else [display(pubmail_line_txt); next_state:=pubmail2]];
  pubmail3: prompt_with(select_category_txt);
  pubmail4: {select a category}
    [if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str=null then
       next_state:=main_menu
     else if str[1]=mn[8][1] {?} or else eq(str,ss[40]) then {HELP}
       [display(pubmail_header_txt); next_state:=pubmail1]
     else
       [q[wx].pm:=pubmail;
        while q[wx].pm<>nil and then
	      ((q[wx].pm^.letter[1]<>str[1]) or (not see_pub)) do
          q[wx].pm:=q[wx].pm^.link;
        if q[wx].pm=nil and then str[1]=mn[12][9] {N} then
          [q[wx].pm:=pubmail;
           while q[wx].pm<>nil and then (not see_pub) do
	     q[wx].pm:=q[wx].pm^.link];
        if q[wx].pm=nil then
          [if str[1]=mn[8][3] {Q}
             then next_state:=main_menu
             else [display(bad_category_txt); next_state:=pubmail3]]
        else
          [if q[wx].pm^.qaire<>0 and then
              q[wx].my.mult_answer[ord(q[wx].pm^.qaire)][1]=' '
             then prompt_with(special_qaire_txt)
             else [prompt_with(pubcat_menu_txt); next_state:=pubmail6]]]];
  pubmail4a: {answer special questionnaire}
    if nagree(s) then
      [q[wx].qr:=ord(q[wx].pm^.qaire); q[wx].qs:=qair[q[wx].qr];
       q[wx].index:=1; q[wx].return_state:=pubmail5;
       display(nextq_txt); next_state:=mult_ch1a]
    else
      [if q[wx].pm^.mandatory and then q[wx].level<9
         then [prompt_with(select_category_txt); next_state:=pubmail4]
         else [prompt_with(pubcat_menu_txt); next_state:=pubmail6]];
  end {case};
  q[wx].state:=next_state;
end {bbs3};

END.
