{$debug-}
{$line-}

{$include: 'types.int'}
{$include: 'globals.int'}
{$include: 'utils.int'}
{$include: 'sutils.int'}
{$include: 'fs_pkg.int'}
{$include: 'xmodem.int'}
{$include: 'load.int'}
{$include: 'script2b.int'}

IMPLEMENTATION OF script2b;

USES types,globals,utils,sutils,fs_pkg,xmodem,load;

{DLX Bulletin Board System V7.0

 FREEWARE NOTICE

 DLX V7.0 is placed in the public domain by its author, Richard Gillmann.
 Anyone who wishes to may run the program, copy it, or modify it for
 any purpose, including commercial gain.}

{***Interface to the assembler utilities packages***}
{$include: 'pasasm.int'}
{$include: 'newasm.int'}

procedure bbs2b{consts s : lstring; var str : lstring};
var
  i,j : integer;
  next_state : task;
  p : para;
  i4 : integer4;
  fl : boolean;
begin
  next_state:=succ(q[wx].state);
  case q[wx].state of
  libr_menu: {first menu you see after typing L at main menu}
    prompt_with(libr_menu_txt);
  libr: {select category menu processing}
    if time_check(true) then
      [display(time_limit_txt); next_state:=snip]
    else if str=null or else str[1]=mn[9][4] {Q} then
      next_state:=main_menu
    else if str[1]=mn[9][1] {?} or else
            ((str.len=1) and (str[1]=mn[9][2])) {L} or else
            eq(str,ss[40]) {HELP} then
      [nth_path(path_library,1,str);
       konkat(str,'\'); konkat(str,ss[51]); {MENU}
       if fs_openr(wx,str)=0 then
         [q[wx].return_state:=libr_menu;
          q[wx].bflag:=true; {expand & codes}
          next_state:=display_file]
       else
         [fs_close(wx);
          nth_path(path_library,1,str); konkat(str,'\*.*'*chr(0));
	  w^[wx].output:=dir(str,16#10); w^[wx].crud:=true;
          if w^[wx].output=nill then
            next_state:=libr_menu
          else
	    [w^[wx].node_type:=nt_display; q[wx].return_state:=libr_menu]]]
    else if str.len=1 and then str[1]=mn[9][3] {S} then
      [prompt_with(which_subdir_txt); next_state:=libr1]
    else
      [kopylst(str,q[wx].filename); q[wx].index:=1;
       next_state:=libr2];
  libr_nomenu:
    [w^[wx].output:=dir(NULL,0); w^[wx].crud:=true;
     if w^[wx].output=nill
       then next_state:=q[wx].return_state
       else [w^[wx].node_type:=nt_display; next_state:=libr_nomenu]];
  libr1: {get category name}
    if q[wx].level=9 and then str.len>0 and then
       ((str[1]='\') or (str[2]=':')) then
      [kopylst(str,q[wx].pathname); kopylst(str,q[wx].filename);
       display(new_subdir_txt); next_state:=libr3_menu]
    else
      [kopylst(str,q[wx].filename); q[wx].index:=1];
  libr2: {locate correct category path from;multiple;listing}
    [nth_path(path_library,q[wx].index,q[wx].pathname);
     if q[wx].pathname=null then
       [display(bad_subdir_txt); next_state:=libr_menu]
     else
       [uloc:=ord(q[wx].pathname.len)+2;
        konkat(q[wx].pathname,'\'); konkat(q[wx].pathname,q[wx].filename);
        if exist_dir(q[wx].pathname) then
	  [if filename_ok(q[wx].filename) or else q[wx].level=9
	     then display(new_subdir_txt)
             else [display(bad_subdir_txt); next_state:=libr_menu]]
	else
	  [q[wx].index:=q[wx].index+1; next_state:=libr2]]];
  libr3_menu: {display category menu}
    prompt_with(libr3_menu_txt);
  libr3: {process category menu selection -- q[wx].pathname all set up}
    [q[wx].xfermode:=fAscii;
     if q[wx].buffer<>RETYPE(bpara,nill)
       then [disbpara(q[wx].buffer); q[wx].buffer:=RETYPE(bpara,nill)];
     if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str=null or else str[1]=mn[9][4] {Q} then
       [prompt_with(libr_menu_txt); next_state:=libr]
     else if str[1]=mn[9][1] {?} or else eq(str,ss[40]) then {HELP}
       [display(libr3_help_txt); next_state:=libr3_menu]
     else if str.len=1 and then str[1]=mn[9][2] {L} then
       [copylst(q[wx].pathname,str);
        konkat(str,'\'); konkat(str,ss[51]); {MENU}
        if fs_openr(wx,str)=0 then
          [q[wx].return_state:=libr3_menu;
           q[wx].bflag:=false; {don't expand & codes - &LO could be problem}
           next_state:=display_file]
        else
          [fs_close(wx);
           kopylst(q[wx].pathname,str); konkat(str,'\*.*'*chr(0));
	   w^[wx].output:=dir(str,16#10); w^[wx].crud:=true;
           if w^[wx].output=nill then
             next_state:=libr3_menu
           else
	     [q[wx].return_state:=libr3_menu;
	      w^[wx].node_type:=nt_display; next_state:=libr_nomenu]]]
     else if str.len=1 and then str[1]=mn[9][5] {D} then
       [if q[wx].level<priv_download then
          [display(read_access_txt); next_state:=libr3_menu]
        else if q[wx].level<9 and then
		d4dnload and then uc(q[wx].pathname[uloc])<>mn[8][6] {D} then
	  [display(d4dnload_txt); next_state:=libr3_menu]
        else
          [q[wx].bflag:=true; {download}
           prompt_with(which_protocol_txt); next_state:=libr3a]]
     else if str.len=1 and then str[1]=mn[9][6] {U} then
       [if q[wx].level<priv_upload then
          [display(read_access_txt); next_state:=libr3_menu]
        else if q[wx].level<9 and then
                u4upload and then uc(q[wx].pathname[uloc])<>mn[8][5] {U} then
          [display(u4upload_txt); next_state:=libr3_menu]
        else 
          [if q[wx].pathname.len>=2 and then q[wx].pathname[2]=':'
             then i:=ord(uc(q[wx].pathname[1]))-ord('@')
             else i:=0;
           if q[wx].level<9 and then megs_free(i) < megs_min and then
	      scaneq(ord(q[wx].pathname.len),';',q[wx].pathname,1)
	      	< ord(q[wx].pathname.len) then
	     [display(no_diskspace_txt); next_state:=libr3_menu]
           else
             [q[wx].bflag:=false; {upload}
              prompt_with(which_protocol_txt); next_state:=libr3a]]]
     else if q[wx].level>=priv_ad and then filename_ok(str) and then
             ((not d4dnload) or (q[wx].level=9) or
              (uc(q[wx].pathname[uloc])=mn[8][6])) {D} then
       [kopylst(str,q[wx].filename);
        if str[1]<>'\' then if str.len=1 or else str[2]<>':' then
          [copylst(q[wx].pathname,str); concat(str,'\'); concat(str,s)];
        q[wx].count:=fs_openr(wx,str); q[wx].count4:=0;
        if q[wx].count=0 and then not fs_eof(wx) then
          [q[wx].return_state:=libr_post_down;
           q[wx].bflag:=false; next_state:=display_file]
	else if exist_dir(str) then
	  [copylst(s,q[wx].filename);
	   uloc:=ord(q[wx].pathname.len)+2;
	   kopylst(str,q[wx].pathname);
           display(new_subdir_txt); next_state:=libr3_menu]
        else
          [if q[wx].count<>0
	     then display(nofile_txt)
	     else display(download_error_txt);
           fs_close(wx); next_state:=libr3_menu]]
     else
       [prompt_with(libr3_menu_txt); next_state:=libr3]];
  libr3a_menu: prompt_with(which_protocol_txt);
  libr3a: {select a protocol}
    [if time_check(true) then
       [display(time_limit_txt); next_state:=snip]
     else if str=null or else str[1]=mn[15][2] {Q} then
       next_state:=libr3_menu
     else if str[1]=mn[15][1] {?} or else eq(str,ss[40]) then {HELP}
       [display(protocol_help_txt); next_state:=libr3a_menu]
     else if str[1]=mn[15][3] {A} then {ASCII transfer}
       [if q[wx].bflag {downloading} then
	  prompt_with(file2transfer_txt)
	else
          [prompt_with(describe_file_txt); next_state:=libr_au0]]
     else if wx>0 then
       [if str[1]=mn[15][4] {X} then {XMODEM transfer}
          [q[wx].xfermode:=fXmodem or f128 or fCrc;
           q[wx].state2:=0;
           if q[wx].bflag {downloading} then
             [prompt_with(file2transfer_txt); next_state:=libr_xd]
           else
             [prompt_with(describe_file_txt); next_state:=libr_xu0]]
        else
          [if str[1]=mn[15][5] {K} then
             q[wx].xfermode:=fXmodem or fCrc		{XMODEM-1K}
           else if str[1]=mn[15][6] {E} then
             q[wx].xfermode:=fXmodem or fCrc or fNak	{XMODEM-1K-G}
	   else
	     next_state:=libr3a_menu;
           if next_state<>libr3a_menu then
             [q[wx].state2:=0;
              q[wx].buffer:=newbpara;
	      if q[wx].buffer=RETYPE(bpara,nill) then
                [display(nomem_txt); next_state:=libr3a_menu]
              else if q[wx].bflag {downloading} then
                [prompt_with(file2transfer_txt); next_state:=libr_xd]
              else
                [prompt_with(describe_file_txt); next_state:=libr_xu0]]]]
     else
       next_state:=libr3a_menu];
  libr_transfer: {begin ASCII download}
    [kopylst(str,q[wx].filename); next_state:=libr3_menu;
     if filename_ok(str) or else ((str<>null) and (q[wx].level=9)) then
       [if str[1]<>'\' then if str.len=1 or else str[2]<>':' then
	  [copylst(q[wx].pathname,str); konkat(str,'\'); konkat(str,s)];
	q[wx].count:=fs_openr(wx,str); q[wx].count4:=0;
	if q[wx].count=0 and then not fs_eof(wx) then
	  [q[wx].return_state:=libr_post_down;
	   w^[wx].more:=-MAXINT; {suppress page pause}
	   q[wx].bflag:=false;
	   display(begin_ascii_dl_txt); next_state:=display_file]
	else
	   [if q[wx].count<>0
	      then display(nofile_txt)
	      else display(download_error_txt);
	    fs_close(wx)]]
     else
       display(bad_filename_txt)];
  libr_xd:
    case q[wx].state2 of
      0 : if filename_ok(str) or else ((str<>null) and (q[wx].level=9)) then
            [kopylst(str,q[wx].filename); next_state:=libr3_menu;
             copylst(q[wx].pathname,str); konkat(str,'\'); konkat(str,s);
             if exist_file(str) then
	       [w^[wx].ch0:=filesize(str);
                i:=ord(w^[wx].ch0 div (6*w^[wx].baud)); {raw bandwidth}
                i:=((i*5) div 4)+1; {protocol overhead and rounding}
		{i = estimated download time in minutes}
		if nBump=0 and then
		   (i > (time_limit[q[wx].level] -
                         (q[wx].minutes_on+q[wx].minutes_2day))) then
                  display(file2big_txt)
		else if nBump>0 and then q[wx].level<privnbm and then
		   (i > (bumpmax -
                         (q[wx].minutes_on+q[wx].minutes_2day))) then
                  display(file2big_txt)
                else
                  [fl:=false;
                   for i:=0 to number_of_lines do
                     if i<>wx and then w^[i].file_locked<>nill and then
                        eq(str,w^[i].file_locked^.msg) and then
                        w^[i].rw=writing then
                       [fl:=true; break];
                   if fl then
                     display(download_error_txt)
                   else
                     [q[wx].state2:=1; q[wx].bflag:=true; {downloading}
                      display(begin_download_txt); next_state:=libr_xd]]]
             else
               [display(nofile_txt); next_state:=libr3_menu]]
          else
	    [display(bad_filename_txt); next_state:=libr3_menu];
      666 : [q[wx].state2:=0;
      	     if not q[wx].flag then {error}
               [if q[wx].count=0
                  then display(protocol_error_txt)
                  else display(io_error_txt);
                next_state:=libr3_menu]];
      otherwise [xtransmit; next_state:=libr_xd];
    end {case};
  libr_post_down:
    [if q[wx].xstr<>nill then
       q[wx].xstr^.msg:=null;
     p:=zip(download_post_txt);
     AppendPara2File(p,file_dlog);
     disparas(p);
     display(download_end_txt); next_state:=libr3_menu];
  libr_au0:
    if s.len=0 then
      next_state:=libr3_menu
    else
      [if q[wx].xstr=nill
         then q[wx].xstr:=newpara(s)
         else kopylst(s,q[wx].xstr^.msg);
       if q[wx].xstr^.msg.len>brief_len then
         q[wx].xstr^.msg[0]:=chr(brief_len);
       prompt_with(file2transfer_txt)];
  libr_au:
    [w^[wx].ch0:=jt;
     if s.len=0 then
       next_state:=libr3_menu
     else if q[wx].level=9 then {sysop}
       [kopylst(str,q[wx].filename);
        if str[1]<>'\' then if str.len=1 or else str[2]<>':' then
          [copylst(q[wx].pathname,str); konkat(str,'\'); konkat(str,s)];
        q[wx].count:=fs_openw(wx,str);
        if q[wx].count=0 then
          [setwrap(137); q[wx].count4:=0;
           q[wx].return_state:=libr_post_up; prompt_with(au_txt)]
        else
          [fs_close(wx); display(io_error_txt); next_state:=libr3_menu]]
     else {normal user}
       [if filename_ok(str) then
          [kopylst(str,q[wx].filename);
           copylst(q[wx].pathname,str); konkat(str,'\'); konkat(str,s);
           if exist_file(str) then
             [display(upload_error_txt); next_state:=libr3_menu]
           else
             [q[wx].count:=fs_openw(wx,str);
              if q[wx].count=0 then
                [setwrap(137); q[wx].count4:=0;
                 q[wx].return_state:=libr_post_up; prompt_with(au_txt)]
              else
                [fs_close(wx);
                 display(io_error_txt); next_state:=libr3_menu]]]
        else
	  [display(bad_filename_txt); next_state:=libr3_menu]]];
  libr_au_line:
    [q[wx].count:=fs_puts(wx,s);
     if q[wx].count=0 then
       [q[wx].count4:=q[wx].count4+ord(s[0])+2;
        prompt_with(null_txt); next_state:=libr_au_line]
     else
       [fs_close(wx);
        display(io_error_txt); next_state:=libr3_menu]];
  libr_xu0:
    if s.len>0 then
      [if q[wx].xstr=nill
         then q[wx].xstr:=newpara(s)
         else kopylst(s,q[wx].xstr^.msg);
       if q[wx].xstr^.msg.len>brief_len then
         q[wx].xstr^.msg[0]:=chr(brief_len);
       prompt_with(file2transfer_txt)]
    else
      [prompt_with(describe_file_txt); next_state:=libr_xu0];
  libr_xu:
    case q[wx].state2 of
      0 : [w^[wx].ch0:=jt;
           if str<>null and then q[wx].level=9 then
             [kopylst(str,q[wx].filename); q[wx].state2:=1;
              display(begin_upload_txt); next_state:=libr_xu]
           else if filename_ok(str) then
             [kopylst(str,q[wx].filename); copylst(q[wx].pathname,str);
              concat(str,'\'); konkat(str,s);
              if exist_file(str) then
                [display(upload_error_txt); next_state:=libr3_menu]
              else
                [q[wx].state2:=1;
                 display(begin_upload_txt); next_state:=libr_xu]]
           else
	     [display(bad_filename_txt); next_state:=libr3_menu]];
      666 : [q[wx].state2:=0;
      	     disbpara(q[wx].buffer); q[wx].buffer:=RETYPE(bpara,nill);
             if q[wx].flag then
               display(upload_end_txt)
             else
               [if q[wx].count=0
                  then display(protocol_error_txt)
                  else display(io_error_txt);
                next_state:=libr3_menu]];
      otherwise [xreceive; next_state:=libr_xu];
    end {case};
  libr_post_up:
    [setwrap(w^[wx].wrapat);
{uploads don't count against time on}
     i4:=jt-w^[wx].ch0; if i4<0 then i4:=i4+one_day; 
     w^[wx].connect_sec0:=w^[wx].connect_sec0+i4;
     w^[wx].ch0:=q[wx].count4; {filesize}
     display(menu_post_txt);
     AppendPara2File(w^[wx].output,file_ulog)];
  libr_post_up2:
    [copylst(q[wx].pathname,str);
     konkat(str,'\'); konkat(str,ss[51]); {MENU}
     p:=zip(menu_post_txt); AppendPara2File(p,str); disparas(p);
     next_state:=libr3_menu];
  match: prompt_with(match_menu_txt);
  match_param:
    if number_query(s,1,6,i) then
      case i of
      1 : prompt_with(lowest_age_txt);
      2 : [prompt_with(highest_age_txt); next_state:=highest_age];
      3 : [prompt_with(last_called_txt); next_state:=last_called];
      4 : [prompt_with(least_times_txt); next_state:=least_times];
      5 : [prompt_with(match_gender_txt); next_state:=what_gender];
      6 : [prompt_with(match_pref_txt); next_state:=what_pref];
      end {case}
    else if str<>null and then str[1]=mn[8][3] {Q} then
      next_state:=main_menu
    else
      [q[wx].index:=largest_member_number;
       display(match_header_txt); next_state:=match_line];
  lowest_age:
    if number_query(s,0,115,i) then
      [q[wx].low_age:=i;
       prompt_with(match_menu_txt); next_state:=match_param]
    else
      [prompt_with(lowest_age_txt); next_state:=lowest_age];
  highest_age:
    if number_query(s,0,115,i) then
      [q[wx].high_age:=i;
       prompt_with(match_menu_txt); next_state:=match_param]
    else
      [prompt_with(highest_age_txt); next_state:=highest_age];
  last_called:
    if number_query(s,0,MAXINT,i) then
      [q[wx].last_called:=i;
       prompt_with(match_menu_txt); next_state:=match_param]
    else
      [prompt_with(last_called_txt); next_state:=last_called];
  least_times:
    if number_query(s,0,MAXINT,i) then
      [q[wx].least_times:=i;
       prompt_with(match_menu_txt); next_state:=match_param]
    else
      [prompt_with(least_times_txt); next_state:=least_times];
  what_gender: {M F or Both}
    if (ord(str[0])>=1) and then ((str[1]=mn[2][1]) or (str[1]=mn[2][2]) or
                                  (str[1]=mn[2][3])) then
      [q[wx].match_gender[1]:=str[1];
       prompt_with(match_menu_txt); next_state:=match_param]
    else
      [prompt_with(match_gender_txt); next_state:=what_gender];
  what_pref: {Str Bi Gay All}
    if str.len>=1 and then ((str[1]=mn[3][1]) or (str[1]=mn[3][2]) or
                            (str[1]=mn[3][3]) or (str[1]=mn[3][4])) then
      [q[wx].match_pref[1]:=str[1];
       prompt_with(match_menu_txt); next_state:=match_param]
    else
      [prompt_with(match_pref_txt); next_state:=what_pref];
  match_line:
    [next_state:=match_line;
     if q[wx].index>member_index_top or else
        (business and member_index^[q[wx].index].active) or else
        (member_index^[q[wx].index].active and
         (q[wx].low_age <= member_index^[q[wx].index].age) and
         (q[wx].high_age >= member_index^[q[wx].index].age) and
         ((q[wx].match_gender = member_index^[q[wx].index].gender) or
          (q[wx].match_gender[1] = mn[2][3] {B})) and
         ((q[wx].match_pref = member_index^[q[wx].index].pref) or
          (member_index^[q[wx].index].pref[1] = mn[3][2] {B}) or
          (q[wx].match_pref[1] = mn[3][4] {A}))) then
       [q[wx].count:=1;
        if disk2u(q[wx].index) and then
           ivalue(q[wx].your.userlevel) >= priv_m then
          [if business then
             display(match_line_txt)
           else
             [i:=ivalue(q[wx].your.age);
              j:=ivalue(q[wx].your.times_called);
              if (q[wx].low_age <= i) and then
                 (q[wx].high_age >= i) and then
                 (q[wx].last_called >= (date2jd(w^[wx].date_of_call) -
                            date2jd(q[wx].your.last_called_date))) and then
                 (q[wx].least_times <= j) and then
                 ((q[wx].match_gender = q[wx].your.gender) or
                  (q[wx].match_gender[1] = mn[2][3] {B})) and then
                 ((q[wx].match_pref = q[wx].your.pref) or
                  (q[wx].your.pref[1] = mn[3][2] {B}) or
                  (q[wx].match_pref[1] = mn[3][4] {A})) then
                display(match_line_txt)]]];
     q[wx].index:=q[wx].index-1;
     if q[wx].index<1 then
       next_state:=q[wx].return_state];
  end {case};
  q[wx].state:=next_state;
end {bbs2b};

END.
