                /* * * * * * * * * * * * * * * * * * * * * * */
                /* CALL    (c) 1992, Jim Groeneveld, CMI-TNO */
                /* * * * * * * * * * * * * * * * * * * * * * */
#define                          VERSION "0.1"
#define                     DATE "22 December 1992"

/*----------------------------------------------------------------------------
 Centrum voor Medische Informatica TNO       <Email>              |  |  |\/|
 TNO Center for Medical Informatics | GROENEVELD@CMI.TNO.NL  |  \_/  |  |  |
 ( CMI-TNO )    | Y. Groeneveld     | GROENEVELD@CMIHP1.UUCP | Jim Groeneveld
 P.O.Box 124    | Wassenaarseweg 56 | GROENEVELD@TNO.NL      | Schoolweg 14
 2300 AC Leiden | 2333 AL Leiden    |                        | 8071 BC Nunspeet
 Nederland.     | (+31|0)71-181810  | Fax (+31|0)71-176382   | 03412-60413
 *----------------------------------------------------------------------------
 *
 * Description: Support for the CALL prefix to .BAT files within batch files
 *              for DOS versions below 3.3, which lack the internal command.
 *
 * Usage: CALL batch [any number of command line parameters]
 *
 * Initially developed and compiled with:
 * PCC Compiler    V1.2c Copyright by Mark DeSmet, 1989   (SW)
 * PCCL   Linker for PCC and PCCA  V1.2b Copyright by Mark DeSmet  1988
 *
 * Also adapted for, compatable with:
 *        MICRO-C 2.0 by Dave Dunfield  1990   (SW)
 *        ZORTECH C 1.07 by Walter Bright 1988 (commercial)
 *        also tested with UNIX C
 * The model used (DOS) is minimal: either tiny or small.
 *----------------------------------------------------------------------------*/

/*-----------------------------------HEADER-----------------------------------*/
#include <stdio.h>

/* #define DEBUG "DEBUG" */
#define PCC 1        /* PCC is DeSmet */
#define MC 2         /* MC is MICRO-C compiler */
#define ZORTECH 3    /* ZORTECH C compiler */
#define COMPILER ZORTECH /* PCC MC ZORTECH NULL */

#if COMPILER==MC     /* Micro-C preprocessor doesn't know/remove #if commands */
  #define void char  /* Micro-C does not know a void type */
#endif

#if COMPILER==ZORTECH     /* or some other compiler */
  #include <string.h>
  #include <stdlib.h>     /* system, getenv */
  #include <process.h>    /* execlp */
#endif

#if COMPILER==NULL /* any other compiler */
  #include <string.h>
#endif

/*-----------------------------------GLOBALS----------------------------------*/
char CommandLine[127];

/*----------------HELP----------------help----------------HELP----------------*/
void help()
{ fprintf (stderr,"\n%s %s %s\n",
  "CALL.EXE (c) 1992 Jim Groeneveld, NL, version",VERSION,DATE);
  fprintf (stderr,"%s\n%s\n","CALL command emulator for DOS  3.3 .",
#if COMPILER==MC
  "Usage: CALL batch [up to 18 replaceable command line parameters]");
                                                                    /*MICRO-C*/
/* Split into separate parts, because MICRO-C compiled program crashes
   if all in one. */
#else
  #if COMPILER==ZORTECH
  "Usage: CALL batch [up to 31 replaceable command line parameters]");
                                                                    /*ZORTECH*/
  #else
  "Usage: CALL batch [any number of command line parameters]");
                                           /*PCC or maybe some other compiler*/
  #endif
#endif
}

/*----------------MAIN----------------main----------------MAIN----------------*/
main(argc,argv)
int argc; char *argv[];                            /* command line arguments */
{ int i,ErrorLevel;
#if COMPILER==ZORTECH
  char *Command;
#endif
  if ( argc == 1 ) { help(); exit(255); };                /* print help info */

#if COMPILER==MC
  for (i=0; i<=127; i++)
  { CommandLine[i]='\0'; }   /* initialize string with binary 0 for MICRO-C */
#else
  #if COMPILER==PCC
    strcat(CommandLine,"/C "); /* initialize string with "/C " for chain, PCC */
  #endif
#endif
  for (i=1; i<argc; i++)
  { strcat(CommandLine,argv[i]);
    if (i<argc-1) strcat(CommandLine," ");
  }

#ifdef DEBUG
  fprintf (stderr,"%s=%d=%d\n",CommandLine,strlen(CommandLine),argc); /*DEBUG*/
/* MICRO-C compiled program gets confused or even crashes with 20 arguments
 * or more;
 * ZORTECH-C compiled program accepts only up to 32 separate arguments; more
 * arguments may crash the system;
 * PCC compiled program accepts any number of arguments within 128 line length.
 */
#endif

#if COMPILER==PCC           /* PCC only; does not know 'system' function */
  chain("C:\COMMAND.COM",CommandLine);    /* or 'exec' function */
/* Assuming COMSPEC=C:\COMMAND.COM; PCC does not know 'getenv' either.
 * COMMAND.COM could be tried to be found in several more or less standard
 * locations (A:\;C:\;A:\DOS;C:\DOS;C:\SYSTEM), but that is cumbersome and
 * not done. Instead another compiler should be used, supporting 'system'.
 * Chain implicitely exits from program CALL without its own ErrorLevel.
 */
#else
  #if COMPILER==ZORTECH
    Command=getenv("COMSPEC");   /* (getenv with MC has different syntax) */
    if ( Command != 0 ) ErrorLevel=execlp(Command,"","/c",CommandLine,NULL);
    else ErrorLevel=execlp("Command","","/c",CommandLine,NULL);
    /* execlp implicitely exits from CALL if successful */
  #else
    ErrorLevel=system(CommandLine);
  #endif

  if ( ErrorLevel<0 )
  { fprintf (stderr,"Command interpreter not found or insufficient memory\n");
    ErrorLevel=254; /* ErrorLevel might be -1 */
  }
  exit(ErrorLevel); /* may be checked as DOS's ERRORLEVEL */
#endif
} /* end of main */

/*---------------------------- That's all folks! -----------------------------

   ---------------------------------History-----------------------------------
Vs. 0.0    Initial working release in DOS BATch language and compiled with
11/12-92   the BATch file compiler BAT2EXEC 1.5 (c) 1990,
           1991 Ziff Communications Co. PC Magazine  Douglas Boling,
           mainly consisting of the essential DOS command lines:
              SHIFT
              %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
           Limitation: only a maximum of 9 replaceable command line parameters
           supported, may be too less if called batch file applies SHIFTing.
Vs. 0.1    Alternative release in C language, supporting any (or some) number of
22/12-92   arguments (depending on compiler) on a line of 127 bytes long.
           Exit codes:
             0 = normal termination
           ??? = Errorlevels of CALLed programs (depending on compiler)
           254 = COMMAND.COM not found or insufficient memory for shell
           255 = no command added, help displayed

   ----------------------------------Future-----------------------------------

   ---------------------------------Remarks-----------------------------------
*/
