DECLARE SUB ShowMouseData (Button%, Horiz%, Vert%)
DECLARE SUB MousDemo ()
'============================================================================
'============================================================================

' sample code 03 to demonstrate techniques for using
' the mouse routines in LangWin

' hit Shift+F5 to run this code.
' follow instructions displayed on screen.

' you must start QuickBASIC as follows:  qb /ah /L langwin
'    /L langwin parameter provides access to LangWin quicklib
'    /ah parameter is needed to allow dynamic arrays > 64k.

DEFINT A-Z

'$INCLUDE: 'LANGWIN.BI' ' TYPE, DECLARE and COMMON definitions for LangWin.
'                         NOTE: LANGWIN.BI contains all definitions found
'                               in QB.BI, so include for QB.BI is not needed.


' get attribute from row 1, col1 so it can be restored upon exit
OrigAttr = SCREEN(1, 1, 1)' save original attribute on screen

' see if we have a mouse
HaveMouse = FALSE     ' default switch to no mouse
IF MouseExists THEN
  IF InitMouse(x) THEN
	HaveMouse = TRUE     ' set switch
  END IF
END IF


LOCATE , , 0             ' start with hidden text cursor

SCREEN 0                 ' text mode


' sample mouse routines
CALL MousDemo



' resoure original screen colors and exit
bbb = (OrigAttr AND &HF0) \ 16  ' mask & shift to get original background
fff = OrigAttr AND &HF          ' mask to get original foreground


PALETTE                           ' restore original palette
CALL SetColor(fff, bbb)           ' restore orig foreground/background
CLS
LOCATE , , 1                      ' make text cursor visible



END

'
'   demonstrate mouse routines from LangWin
'   the WaitTicks routine is also used to demonstrate
'   how to generate a small delay.
'
SUB MousDemo

CLS
LOCATE 1, 1, 0  ' turn off text cursor
INPUT "Hit enter to see mouse pointer.", a$
LOCATE 1, 1
PRINT "Use GetMousePos to get current mouse data in real-time."
PRINT "Mouse data is shown at bottom of screen."
PRINT "Move mouse, click buttons, notice changes in data below."
PRINT "Hit any key to terminate this test."

' print mask
LOCATE 25, 1
PRINT "Horiz: xxx   Vert: xxx    Left: xxxx    Right: xxxx    Center: xxxx ";

IF HaveMouse THEN CALL ShowMouseCursor ' display mouse pointer
DO
  CALL GetMousePos(Button, Horiz, Vert)  ' LangWin routine to get mouse data
  CALL ShowMouseData(Button, Horiz, Vert)  'local routine to display data
LOOP WHILE INKEY$ = ""
IF HaveMouse THEN CALL HideMouseCursor 'hide mouse pointer while writing to screen



LOCATE 1, 1
PRINT "Use SetXLimit and SetYLimit to restrict area for mouse pointer."
PRINT "Hit any key to terminate this test.        "
PRINT SPACE$(70);  ' clear line 3
PRINT SPACE$(70);  ' clear line 4

' limit mouse pointer
CALL SetXLimit(20, 100)
CALL SetYLimit(50, 100)

LOCATE 10, 40
PRINT "$", "Click here to see tomorrow's"
LOCATE 11, 43
PRINT "winning lottery number!!"


IF HaveMouse THEN CALL ShowMouseCursor ' display mouse pointer
DO
  CALL GetMousePos(Button, Horiz, Vert)  ' LangWin routine to get mouse data
  CALL ShowMouseData(Button, Horiz, Vert)  'local routine to display data
LOOP WHILE INKEY$ = ""
IF HaveMouse THEN CALL HideMouseCursor 'hide mouse pointer while writing to screen


' un-limit mouse pointer
CALL SetXLimit(0, 639)
CALL SetYLimit(0, 199)



LOCATE 1, 1
CLS
LOCATE 1, 1
PRINT "Now let's use GetButtonPress to count button presses"
PRINT "(useful to determine a double click) and determine"
PRINT "coordinates of the last press."
LOCATE 6, 1
PRINT "While the following bar is shrinking, move mouse around screen."
PRINT "Click left button a few times in various positions."
PRINT "When bar vanishes, I'll show the total number of presses"
PRINT "and the coordinates of the last press."
LOCATE 11, 1
PRINT "Hit any key to start test."
DO: LOOP WHILE INKEY$ = ""
LOCATE 11, 1
PRINT SPACE$(30); ' clear last message

DO

CALL SetMousePos(456, 88)  ' start mouse at specified position

LOCATE 12, 3
PRINT STRING$(40, 219)
IF HaveMouse THEN CALL ShowMouseCursor
LOCATE 12, 3
FOR i = 1 TO 40
	CALL WaitTicks(1)    ' wait a constant amount of timer ticks
   
	' mouse should be hidden before displaying anything on screen.
	' to see effects of not doing this, put mouse in bar while
	' bar is vanishing.
	' by putting a call to "hide" just before the following print,
	' and a call to "show" afterwards, the vanishing bar will not
	' destroy the mouse pointer. unfortunately, the calls to hide/show
	' will reset the button press counter (in the mouse driver, so i
	' can't program around it). thus, by bracketing the following
	' print with hide/show, you'll get 0 as the number of button presses.
   
	PRINT " "; ' clear the current character in the bar to a blank
NEXT
IF HaveMouse THEN CALL HideMouseCursor

BEEP
Button = 0 '  used to tell GetButtonPress that we want data for left button
CALL GetButtonPress(Button, Count, Horiz, Vert)   ' get mouse data

LOCATE 15, 1
PRINT SPACE$(78);  'clear line
LOCATE 15, 1
PRINT "Number of presses: "; Count, "Horiz: "; Horiz, "Vert: "; Vert;
PRINT "   (coords of last press)"

LOCATE 17, 1
INPUT "Do you want to do this test again (type y or n and hit enter)"; a$

LOCATE 15, 1
PRINT SPACE$(79);   ' clear the last status lines
PRINT SPACE$(79);
PRINT SPACE$(79);


LOOP WHILE a$ <> "n"

END SUB

'
'  display mouse data at bottom of screen
'
SUB ShowMouseData (Button, Horiz, Vert)
   
	' display coordinates
	LOCATE 25, 8
	PRINT Horiz;
	LOCATE 25, 20
	PRINT Vert;
  
	' left button status
	l$ = "UP  "
	IF (Button AND 1) = 1 THEN l$ = "DOWN"
	' right button status
	r$ = "UP  "
	IF (Button AND 2) = 2 THEN r$ = "DOWN"
	' center button status
	c$ = "UP  "
	IF (Button AND 4) = 4 THEN c$ = "DOWN"
   
	' display button status
	LOCATE 25, 33
	PRINT l$;
	LOCATE 25, 48
	PRINT r$;
	LOCATE 25, 64
	PRINT c$;


END SUB

