Extrn StringAssign:far

;PROGRAM - MHSTFILL.ASM

Code segment para public 'code'
assume cs:Code
	
Public FillStringArray
FillStringArray Proc Far
; DIM Array$(NumberOfElements)
; CALLS FillStringArray
;                (Array$(LowestElementToFill%))

; This routine works with near and far strings.

Comment |

	Note the "S" in the CALLS syntax. This forces
	BC to pass the	pointer to the array descriptors
	instead of just passing a pointer to a *copy*
	of the first descriptor. |

	push bp
	mov bp,sp
	push si
	push di
	push ds
	cld				; Clear the direction flag.

	mov bp,[bp+6]	; Point to 1st string descriptor
	mov ax,cs
	mov ds,ax		; Point DS:SI at our data.
	mov si,offset NumberOfDataItems
	lodsw				; Move number of data items
	mov cx,ax		;   into CX register for count.
FillStringLoop:
	lodsw				; Length of our data item
	or ax,ax			; is it a zero? (null string)
	jz SkipThisString	; yes - don't process it
	
	push cx				; save our critical registers
	push si	
	push ax
	push ds
	
	mov bx,ss	; StringAssign expects DS=DGROUP,
	mov ds,bx	;   but docs don't tell you that!
	push cs		; segment of string to be assigned
	push si		; offset of string 
	push ax		; length of string
	push ss		; segment of descriptor
	push bp		; offset of descriptor
	xor ax,ax	; function 0 - assign string
	push ax
	call StringAssign		; assign the string

	pop ds
	pop ax				; retrieve critical registers
	pop si
	add si,ax			; point to next item's length
	pop cx
SkipThisString:
	add bp,4				; point to next descriptor
	loop FillStringLoop		; cook until done	
	pop ds
	pop di
	pop si
	pop bp
	ret 4

FillStringArray Endp
	
NumberOfDataItems	dw 10	 ; # of elements to fill.
					
ActualData	dw 3			 ; Length of string
		db 'One'		; String data (both repeated for
		dw 3			; each data element.
		db 'Two'
		dw 5
		db 'Three'
		dw 4
		db 'Four'
		dw 4
		db 'Five'
		dw 3
		db 'Six'
		dw 5
		db 'Seven'
		dw 5
		db 'Eight'
		dw 4
		db 'Nine'
		dw 3
		db 'Ten'

Code ends
	end
