
;************************************************************************
;* Comando: cvista()
;* Comentarios: este comando se utiliza para crear las distintas vistas
;* de los equipos de las subestaciones. A partir del dibujo se generan
;* los bloques de las vista, la vistas se nombran de la siguiente forma
;* (prefijo)+"_"+(nombre equipo) donde prefijo puede ser: "x", "y", "z",
;* "-x", "-y", "-z", "3d", "ala". Por ejemplo "ala_desconectador"
;************************************************************************
;
; change.log
; 
; 26/10/94    C.Perigault    Se arreglo una mala ubicacion de los parentesis
;                            que cerraban el defun de cVista, confundiendo 
;                            la funcion rotacion
;
; 26/10/94    C.Perigault    El angulo de rotacion del ala debe ser 90 (y no 0)
                             en la ListaRotacion

(defun c:cVista ( / osmode cmdecho gridmode ListaRotacion
		    NombreEquipo vista insercion conjunto
		    NombreBloque reemplazar temp NombreEquipo)
  (setq ucs 1)
  (setq wcs 0)
  ; guardamos el estado del sistema del usuario
  (setq osmode   (getvar "OSMODE"  ))
  (setq cmdecho  (getvar "CMDECHO" ))
  (setq gridmode (getvar "GRIDMODE"))
  (setvar "GRIDMODE" 0)
  (setvar "CMDECHO"  0)
  (setvar "OSMODE"   0)
  ; en esta lista se guardan la rotaciones que se le deben hacer
  ; al bloque para que al insertarse lo hagan segun la vista
  (setq ListaRotacion '(("x"   ( 90 0  90))
			("y"   ( 90 0 180))
			("z"   (  0 0   0))
			("-x"  ( 90 0 -90))
			("-y"  ( 90 0   0))
			("-z"  (180 0   0))
			("3d"  (  0 0   0))
			("ala" ( 90 0   0))))

   (setq NombreEquipo (getstring "\nIngrese el nombre del equipo : "))
   (setq vista nil)
   (while (not (equal vista "quit"))
     (initget 1 "x y z -x -y -z 3d Ala Quit")
     (setq vista (strcase (getkword "\nx/y/z/-x/-y/-z/Ala/3d/Quit : ")t))
     (if (not (equal vista "quit"))
       (progn
	 ; seleccionamos el bloque y su punto de insercion
	 (setvar "OSMODE" osmode)
	 (setq insercion (getpoint "\nPunto de insercion :"))
	 (setvar "OSMODE" 0)
	 (setq conjunto (ssget))

	 (setq NombreBloque (strcat vista "_" NombreEquipo))
	 ; vemos si el bloque existe de ser asi le preguntamos
	 ; al usuario si desea redefinirlo
	 (if (tblsearch "BLOCK" NombreBloque)
	   ; si existe preguntamos al usuario si desea reemplazarlo
	   (progn
	     (initget 1 "Si No")
	     (setq reemplazar
	     (strcase
	       (getkword
		 (strcat "\nEl bloque " NombreBloque " ya existe reemplazarlo (s/n)"))t))
	     (if (equal reemplazar "si")
	       (progn
		 ; debemos copiar el bloque ya que al crearlo lo borramos
		 (command "COPY" conjunto "" '(0 0 0) '(0 0 0))
		 ; aplicamos las rotaciones necesarias para que se inserte
		 ; segun la vista
		 (setq temp (cadr (assoc vista ListaRotacion)))
		 (Rotacion conjunto insercion (car temp) (cadr temp) (caddr temp))
		 (command "BLOCK" NombreBloque "Y" insercion conjunto "")
		 (redraw))))
	 (progn
	   ; debemos copiar el bloque ya que al crearlo lo borramos
	   (command "COPY" conjunto "" '(0 0 0) '(0 0 0))
	   (setq temp (cadr (assoc vista ListaRotacion)))
	   ; aplicamos las rotaciones necesarias para que se inserte
	   ; segun la vista
	   (Rotacion conjunto insercion (car temp) (cadr temp) (caddr temp))
	   (command "BLOCK" NombreBloque insercion conjunto "")
	   (redraw))))))
  ; volvemos al estado original de acad
  (setvar "GRIDMODE" gridmode)
  (setvar "OSMODE"   osmode  )
  (setvar "CMDECHO"  cmdecho )
)

;********************************************************************
;* Funcion : Rotacion (conjunto punto rx ry rz)
;* Parametros :
;*              - conjunto : entidades que se desean rotar
;*              - punto    : punto de rotacion
;*              - rx       : rotacion con respecto al eje x
;*              - ry       : rotacion con respecto al eje y
;*              - rz       : rotacion con respecto al eje z
;********************************************************************
(defun Rotacion (conjunto  punto rx ry rz)
  (setq punto (trans punto ucs wcs))
  (command "UCS" "Y" "90")
  (command "ROTATE" conjunto "" (trans punto wcs ucs) rx)
  (command "UCS" "P")
  (command "UCS" "X" "-90")
  (command "ROTATE" conjunto "" (trans punto wcs ucs)  ry)
  (command "UCS" "P")
  (command "ROTATE" conjunto "" (trans punto wcs ucs)  rz)

)
